/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Iterator;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public final class MWOrderingItem
extends MWAttributeItem
implements Ordering {
    private volatile boolean ascending;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWOrderingItem.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAttributeItem.class);
        ((AbstractDirectMapping)xMLDescriptor.addDirectMapping("ascending", "ascending/text()")).setNullValue((Object)Boolean.TRUE);
        return xMLDescriptor;
    }

    private MWOrderingItem() {
    }

    MWOrderingItem(MWRelationalReadAllQuery mWRelationalReadAllQuery, MWQueryable mWQueryable) {
        super((MWQuery)mWRelationalReadAllQuery, mWQueryable);
    }

    MWOrderingItem(MWRelationalReadAllQuery mWRelationalReadAllQuery, Iterator iterator) {
        super((MWQuery)mWRelationalReadAllQuery, iterator);
    }

    MWOrderingItem(MWRelationalReadAllQuery mWRelationalReadAllQuery, Iterator iterator, Iterator iterator2) {
        super(mWRelationalReadAllQuery, iterator, iterator2);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.ascending = true;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isDesending() {
        return !this.isAscending();
    }

    public void setAscending(boolean bl) {
        boolean bl2 = this.ascending;
        this.ascending = bl;
        this.firePropertyChanged("ascending", bl2, this.ascending);
    }

    public void removeSelfFromParent() {
        ((MWRelationalReadAllQuery)this.getParentQuery()).removeOrderingItem(this);
    }

    public Problem queryableNullProblem() {
        return this.buildProblem("0252", this.getParentQuery().signature(), new Integer(((MWRelationalReadAllQuery)this.getParentQuery()).indexOfOrderingItem(this) + 1));
    }

    public Problem queryableInvalidProblem(MWQueryable mWQueryable) {
        return this.buildProblem("0253", mWQueryable.displayString(), this.getParentQuery().signature());
    }

    public boolean isQueryableValid(MWQueryable mWQueryable) {
        return mWQueryable.isValidForReadAllQueryOrderable();
    }

    protected void adjustRuntimeQuery(ObjectLevelReadQuery objectLevelReadQuery) {
        Expression expression = this.getQueryableArgument().runtimeExpression(objectLevelReadQuery.getExpressionBuilder());
        if (this.isAscending()) {
            ((ReadAllQuery)objectLevelReadQuery).addOrdering(expression.ascending());
        } else {
            ((ReadAllQuery)objectLevelReadQuery).addOrdering(expression.descending());
        }
    }

    public String displayString() {
        String string = super.displayString() + " (";
        string = this.isAscending() ? string + "Ascending" : string + "Descending";
        return string + ")";
    }
}

