/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorQueryParameterHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWQueryParameterArgument
extends MWArgument {
    private MWDescriptorQueryParameterHandle queryParameterHandle;
    public static final String QUERY_PARAMETER_PROPERTY = "queryParameter";

    private MWQueryParameterArgument() {
    }

    MWQueryParameterArgument(MWBasicExpression mWBasicExpression) {
        super(mWBasicExpression);
    }

    MWQueryParameterArgument(MWBasicExpression mWBasicExpression, MWQueryParameter mWQueryParameter) {
        this(mWBasicExpression);
        this.queryParameterHandle.setQueryParameter(mWQueryParameter);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.queryParameterHandle = new MWDescriptorQueryParameterHandle(this, this.buildQueryParameterScrubber());
    }

    public String getType() {
        return "parameter";
    }

    public MWQueryParameter getQueryParameter() {
        return this.queryParameterHandle.getQueryParameter();
    }

    private MWBasicExpression getBasicExpression() {
        return (MWBasicExpression)this.getParent();
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkParameter(list);
    }

    private void checkParameter(List list) {
        if (this.getQueryParameter() == null) {
            String string = this.getBasicExpression().getParentQuery().getName();
            String string2 = this.getBasicExpression().getIndex();
            list.add(this.buildProblem("0248", string2, string));
        }
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.queryParameterHandle);
    }

    private MWHandle.NodeReferenceScrubber buildQueryParameterScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWQueryParameterArgument.this.setQueryParameter(null);
            }

            public String toString() {
                return "MWQueryParameterArgument.buildQueryParameterScrubber()";
            }
        };
    }

    public void undoChange(String string, Object object, Object object2) {
        if (string == QUERY_PARAMETER_PROPERTY) {
            this.setQueryParameter((MWQueryParameter)object);
        }
    }

    public String displayString() {
        if (this.getQueryParameter() == null) {
            return "";
        }
        return this.getQueryParameter().getName();
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append("queryParameter = ");
        if (this.getQueryParameter() != null) {
            stringBuffer.append(this.getQueryParameter().getName());
        }
    }

    public void setQueryParameter(MWQueryParameter mWQueryParameter) {
        MWQueryParameter mWQueryParameter2 = this.getQueryParameter();
        this.queryParameterHandle.setQueryParameter(mWQueryParameter);
        this.firePropertyChanged(QUERY_PARAMETER_PROPERTY, mWQueryParameter2, this.getQueryParameter());
        this.getBasicExpression().getRootCompoundExpression().propertyChanged(this, QUERY_PARAMETER_PROPERTY, mWQueryParameter2, mWQueryParameter);
    }

    Expression runtimeExpression(ExpressionBuilder expressionBuilder) {
        return expressionBuilder.getParameter(this.getQueryParameter().getName());
    }

    static MWQueryParameterArgument convertFromRuntime(MWBasicExpression mWBasicExpression, ParameterExpression parameterExpression) {
        String string = parameterExpression.getField().getName();
        MWQueryParameter mWQueryParameter = mWBasicExpression.getParentQuery().getParameterNamed(string);
        return new MWQueryParameterArgument(mWBasicExpression, mWQueryParameter);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWQueryParameterArgument.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWArgument.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("queryParameterHandle");
        xMLCompositeObjectMapping.setGetMethodName("getQueryParameterHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setQueryParameterHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWDescriptorQueryParameterHandle.class);
        xMLCompositeObjectMapping.setXPath("query-parameter-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWDescriptorQueryParameterHandle getQueryParameterHandleForTopLink() {
        return this.queryParameterHandle.getQueryParameter() == null ? null : this.queryParameterHandle;
    }

    private void setQueryParameterHandleForTopLink(MWDescriptorQueryParameterHandle mWDescriptorQueryParameterHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildQueryParameterScrubber();
        this.queryParameterHandle = mWDescriptorQueryParameterHandle == null ? new MWDescriptorQueryParameterHandle(this, nodeReferenceScrubber) : mWDescriptorQueryParameterHandle.setScrubber(nodeReferenceScrubber);
    }
}

