/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgumentElement;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgumentParent;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWQueryableArgument
extends MWArgument {
    private volatile MWQueryableArgumentElement queryableArgumentElement;
    public static final String QUERYABLE_ARGUMENT_ELEMENT_PROPERTY = "queryableArgumentElement";

    private MWQueryableArgument() {
    }

    MWQueryableArgument(MWQueryableArgumentParent mWQueryableArgumentParent) {
        super(mWQueryableArgumentParent);
    }

    MWQueryableArgument(MWQueryableArgumentParent mWQueryableArgumentParent, MWQueryable mWQueryable) {
        this(mWQueryableArgumentParent);
        this.setQueryableArgument(mWQueryable);
    }

    MWQueryableArgument(MWQueryableArgumentParent mWQueryableArgumentParent, Iterator iterator) {
        this(mWQueryableArgumentParent);
        this.setQueryableArgument(iterator);
    }

    MWQueryableArgument(MWQueryableArgumentParent mWQueryableArgumentParent, Iterator iterator, Iterator iterator2) {
        this(mWQueryableArgumentParent);
        this.setQueryableArgument(iterator, iterator2);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.queryableArgumentElement);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.queryableArgumentElement = new MWQueryableArgumentElement(this);
    }

    public String getType() {
        return "queryKey";
    }

    public String displayString() {
        return this.getQueryableArgumentElement().displayString();
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkQueryable(list);
    }

    private void checkQueryable(List list) {
        MWQueryable mWQueryable = this.getQueryableArgumentElement().getQueryable();
        if (mWQueryable == null) {
            this.getQueryableArgumentParent().addQueryableNullProblemTo(list);
        } else if (!this.getQueryableArgumentParent().isQueryableValid(mWQueryable)) {
            list.add(this.getQueryableArgumentParent().queryableInvalidProblem(mWQueryable));
        }
    }

    public void nodeRemoved(Node node) {
        super.nodeRemoved(node);
        if (node instanceof MWMapping) {
            this.mappingReplaced((MWMapping)node, null);
        }
        if (node instanceof MWQueryKey) {
            for (MWQueryableArgumentElement mWQueryableArgumentElement = this.getQueryableArgumentElement().getJoinedQueryableElement(); mWQueryableArgumentElement != null; mWQueryableArgumentElement = mWQueryableArgumentElement.getJoinedQueryableElement()) {
                if (mWQueryableArgumentElement.getQueryable() != null && !mWQueryableArgumentElement.getQueryable().isLeaf(Filter.NULL_INSTANCE)) continue;
                this.getQueryableArgumentElement().setQueryableToNull();
                break;
            }
        }
    }

    public void descriptorUnmapped(Collection collection) {
        super.descriptorUnmapped(collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.mappingReplaced((MWMapping)iterator.next(), null);
        }
    }

    public void mappingReplaced(MWMapping mWMapping, MWMapping mWMapping2) {
        super.mappingReplaced(mWMapping, mWMapping2);
        for (MWQueryableArgumentElement mWQueryableArgumentElement = this.getQueryableArgumentElement().getJoinedQueryableElement(); mWQueryableArgumentElement != null; mWQueryableArgumentElement = mWQueryableArgumentElement.getJoinedQueryableElement()) {
            if (mWQueryableArgumentElement.getQueryable() != null && !mWQueryableArgumentElement.getQueryable().isLeaf(Filter.NULL_INSTANCE)) continue;
            this.getQueryableArgumentElement().setQueryableToNull();
            break;
        }
    }

    public void undoChange(String string, Object object, Object object2) {
        if (string == QUERYABLE_ARGUMENT_ELEMENT_PROPERTY) {
            this.setQueryableArgumentElement((MWQueryableArgumentElement)object);
        }
    }

    public MWQueryableArgumentElement getQueryableArgumentElement() {
        return this.queryableArgumentElement;
    }

    public void setQueryableArgument(MWQueryable mWQueryable) {
        ArrayList<MWQueryable> arrayList = new ArrayList<MWQueryable>();
        arrayList.add(mWQueryable);
        this.setQueryableArgument(arrayList.iterator());
    }

    public void setQueryableArgument(Iterator iterator, Iterator iterator2) {
        if (!iterator.hasNext()) {
            throw new UnsupportedOperationException();
        }
        MWQueryable mWQueryable = (MWQueryable)iterator.next();
        iterator.remove();
        MWQueryableArgumentElement mWQueryableArgumentElement = new MWQueryableArgumentElement(this, mWQueryable);
        if (iterator2.hasNext()) {
            mWQueryableArgumentElement.setAllowsNull((Boolean)iterator2.next());
            iterator2.remove();
        }
        if (iterator.hasNext()) {
            mWQueryableArgumentElement.setJoinedQueryable(iterator, iterator2);
        }
        this.setQueryableArgumentElement(mWQueryableArgumentElement);
    }

    public void setQueryableArgument(Iterator iterator) {
        this.setQueryableArgument(iterator, NullIterator.instance());
    }

    private void setQueryableArgumentElement(MWQueryableArgumentElement mWQueryableArgumentElement) {
        MWQueryableArgumentElement mWQueryableArgumentElement2 = this.getQueryableArgumentElement();
        this.queryableArgumentElement = mWQueryableArgumentElement;
        this.firePropertyChanged(QUERYABLE_ARGUMENT_ELEMENT_PROPERTY, mWQueryableArgumentElement2, mWQueryableArgumentElement);
        this.getQueryableArgumentParent().propertyChanged(this, QUERYABLE_ARGUMENT_ELEMENT_PROPERTY, mWQueryableArgumentElement2, mWQueryableArgumentElement);
    }

    void recalculateQueryables() {
        MWQueryableArgumentElement mWQueryableArgumentElement = this.getQueryableArgumentElement();
        while (mWQueryableArgumentElement.getJoinedQueryableElement() != null) {
            if (!mWQueryableArgumentElement.getJoinedQueryableElement().getQueryable().subQueryableElements(Filter.NULL_INSTANCE).contains(mWQueryableArgumentElement.getQueryable())) {
                this.getQueryableArgumentElement().setQueryableToNull();
                break;
            }
            mWQueryableArgumentElement = mWQueryableArgumentElement.getJoinedQueryableElement();
        }
        if (!((MWRelationalDescriptor)((Object)this.getQueryableArgumentParent().getParentQuery().getOwningDescriptor())).getQueryables(Filter.NULL_INSTANCE).contains(mWQueryableArgumentElement.getQueryable())) {
            this.getQueryableArgumentElement().setQueryableToNull();
        }
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append(this.getQueryableArgumentElement());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWQueryableArgument.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWArgument.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName(QUERYABLE_ARGUMENT_ELEMENT_PROPERTY);
        xMLCompositeObjectMapping.setReferenceClass(MWQueryableArgumentElement.class);
        xMLCompositeObjectMapping.setXPath("queryable-argument-element");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    Expression runtimeExpression(ExpressionBuilder expressionBuilder) {
        return this.queryableArgumentElement.convertToRuntime(expressionBuilder);
    }

    static MWQueryableArgument convertFromRuntime(MWBasicExpression mWBasicExpression, QueryKeyExpression queryKeyExpression) {
        MWQueryableArgument mWQueryableArgument = new MWQueryableArgument(mWBasicExpression);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        arrayList.add(0, queryKeyExpression.getName());
        arrayList2.add(0, queryKeyExpression.shouldUseOuterJoin());
        while (queryKeyExpression.getBaseExpression().isQueryKeyExpression()) {
            queryKeyExpression = (QueryKeyExpression)queryKeyExpression.getBaseExpression();
            arrayList.add(0, queryKeyExpression.getName());
            arrayList2.add(queryKeyExpression.shouldUseOuterJoin());
        }
        String string = (String)arrayList.remove(0);
        MWQueryable mWQueryable = ((MWTableDescriptor)mWQueryableArgument.getQueryableArgumentParent().getParentQuery().getOwningDescriptor()).queryableNamed(string);
        ArrayList<MWQueryable> arrayList3 = new ArrayList<MWQueryable>();
        arrayList3.add(0, mWQueryable);
        while (arrayList.size() > 0) {
            Iterator iterator = mWQueryable.subQueryableElements(Filter.NULL_INSTANCE).iterator();
            String string2 = (String)arrayList.remove(0);
            while (iterator.hasNext()) {
                MWQueryable mWQueryable2 = (MWQueryable)iterator.next();
                if (!mWQueryable2.getName().equals(string2)) continue;
                mWQueryable = mWQueryable2;
                break;
            }
            arrayList3.add(0, mWQueryable);
        }
        mWQueryableArgument.setQueryableArgument(arrayList3.iterator(), arrayList2.iterator());
        return mWQueryableArgument;
    }
}

