/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWQueryableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWQueryableArgumentElement
extends MWModel {
    private MWQueryableHandle queryableHandle;
    private volatile MWQueryableArgumentElement joinedQueryableElement;
    private volatile boolean allowsNull;
    public static final String ALLOWS_NULL_PROPERTY = "allowsNull";

    private MWQueryableArgumentElement() {
    }

    MWQueryableArgumentElement(MWQueryableArgument mWQueryableArgument, MWQueryable mWQueryable) {
        this(mWQueryableArgument);
        this.queryableHandle.setQueryable(mWQueryable);
    }

    MWQueryableArgumentElement(MWQueryableArgumentElement mWQueryableArgumentElement, MWQueryable mWQueryable) {
        this(mWQueryableArgumentElement);
        this.queryableHandle.setQueryable(mWQueryable);
    }

    MWQueryableArgumentElement(MWQueryableArgument mWQueryableArgument) {
        super(mWQueryableArgument);
    }

    MWQueryableArgumentElement(MWQueryableArgumentElement mWQueryableArgumentElement) {
        super(mWQueryableArgumentElement);
    }

    MWQueryableArgumentElement(MWOrderingItem mWOrderingItem, MWQueryable mWQueryable) {
        super(mWOrderingItem);
        this.queryableHandle.setQueryable(mWQueryable);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.queryableHandle = new MWQueryableHandle(this, this.buildQueryableScrubber());
    }

    public MWQueryable getQueryable() {
        return this.queryableHandle.getQueryable();
    }

    void setQueryableToNull() {
        this.queryableHandle.setQueryable(null);
        this.joinedQueryableElement = null;
    }

    public boolean isAllowsNull() {
        return this.allowsNull;
    }

    public void setAllowsNull(boolean bl) {
        boolean bl2 = this.isAllowsNull();
        this.allowsNull = bl;
        this.firePropertyChanged(ALLOWS_NULL_PROPERTY, bl2, bl);
    }

    public MWQueryableArgumentElement getJoinedQueryableElement() {
        return this.joinedQueryableElement;
    }

    void setJoinedQueryable(Iterator iterator, Iterator iterator2) {
        MWQueryable mWQueryable = (MWQueryable)iterator.next();
        iterator.remove();
        this.joinedQueryableElement = new MWQueryableArgumentElement(this, mWQueryable);
        if (iterator2.hasNext()) {
            this.joinedQueryableElement.setAllowsNull((Boolean)iterator2.next());
            iterator2.remove();
        }
        if (iterator.hasNext()) {
            this.joinedQueryableElement.setJoinedQueryable(iterator, iterator2);
        }
    }

    public String displayString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getJoinedQueryableElement() != null) {
            stringBuffer.append(this.getJoinedQueryableElement().displayString());
            stringBuffer.append('.');
        }
        if (this.getQueryable() != null) {
            stringBuffer.append(this.getQueryable().getName());
            if (this.allowsNull) {
                if (this.getQueryable().usesAnyOf()) {
                    stringBuffer.append("(Allows None)");
                } else {
                    stringBuffer.append("(Allows Null)");
                }
            }
        } else {
            stringBuffer.append("<null>");
        }
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.getJoinedQueryableElement() != null) {
            stringBuffer.append(this.getJoinedQueryableElement().displayString() + ".");
        }
        if (this.getQueryable() != null) {
            stringBuffer.append(this.getQueryable().getName());
            if (this.allowsNull) {
                if (this.getQueryable().usesAnyOf()) {
                    stringBuffer.append("(Allows None)");
                } else {
                    stringBuffer.append("(Allows Null)");
                }
            }
        }
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.queryableHandle);
        if (this.joinedQueryableElement != null) {
            list.add(this.joinedQueryableElement);
        }
    }

    private MWHandle.NodeReferenceScrubber buildQueryableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWQueryableArgumentElement.this.setQueryableToNull();
            }

            public String toString() {
                return "MWQueryableArgumentElement.buildQueryableScrubber()";
            }
        };
    }

    public void descriptorUnmapped(Collection collection) {
        super.descriptorUnmapped(collection);
        if (this.getQueryable() != null && collection.contains(this.getQueryable())) {
            this.setQueryableToNull();
        }
    }

    public void mappingReplaced(MWMapping mWMapping, MWMapping mWMapping2) {
        super.mappingReplaced(mWMapping, mWMapping2);
        if (this.getQueryable() == mWMapping) {
            this.queryableHandle.setQueryable(mWMapping2);
            if (mWMapping2 != null && !mWMapping2.allowsOuterJoin()) {
                this.setAllowsNull(false);
            }
        }
    }

    Expression convertToRuntime(ExpressionBuilder expressionBuilder) {
        expressionBuilder.derivedExpressions = null;
        if (this.getJoinedQueryableElement() != null) {
            Expression expression = this.getJoinedQueryableElement().convertToRuntime(expressionBuilder);
            return this.buildExpressionFrom(expression);
        }
        return this.buildExpressionFrom((Expression)expressionBuilder);
    }

    private Expression buildExpressionFrom(Expression expression) {
        String string = "";
        if (this.getQueryable() != null) {
            string = this.getQueryable().getName();
        }
        if (this.getQueryable() != null && !this.getQueryable().usesAnyOf()) {
            if (!this.allowsNull) {
                return expression.get(string);
            }
            return expression.getAllowingNull(string);
        }
        if (!this.allowsNull) {
            return expression.anyOf(string);
        }
        return expression.anyOfAllowingNone(string);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWQueryableArgumentElement.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("queryableHandle");
        xMLCompositeObjectMapping.setGetMethodName("getQueryableHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setQueryableHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWQueryableHandle.class);
        xMLCompositeObjectMapping.setXPath("queryable-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(ALLOWS_NULL_PROPERTY, "allows-null/text()")).setNullValue((Object)Boolean.FALSE);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("joinedQueryableElement");
        xMLCompositeObjectMapping2.setReferenceClass(MWQueryableArgumentElement.class);
        xMLCompositeObjectMapping2.setXPath("joined-queryable-element");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private MWQueryableHandle getQueryableHandleForTopLink() {
        return this.queryableHandle.getQueryable() == null ? null : this.queryableHandle;
    }

    private void setQueryableHandleForTopLink(MWQueryableHandle mWQueryableHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildQueryableScrubber();
        this.queryableHandle = mWQueryableHandle == null ? new MWQueryableHandle(this, nodeReferenceScrubber) : mWQueryableHandle.setScrubber(nodeReferenceScrubber);
    }
}

