/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public final class MWReportOrderingItem
extends MWAttributeItem
implements Ordering {
    private volatile boolean ascending;
    private volatile String itemName;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWReportOrderingItem.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAttributeItem.class);
        ((AbstractDirectMapping)xMLDescriptor.addDirectMapping("ascending", "ascending/text()")).setNullValue((Object)Boolean.TRUE);
        xMLDescriptor.addDirectMapping("itemName", "item-name/text()");
        return xMLDescriptor;
    }

    private MWReportOrderingItem() {
    }

    MWReportOrderingItem(MWReportQuery mWReportQuery, MWReportAttributeItem mWReportAttributeItem) {
        super((MWQuery)mWReportQuery, mWReportAttributeItem.getQueryableArgument());
        this.itemName = mWReportAttributeItem.getName();
    }

    MWReportOrderingItem(MWReportQuery mWReportQuery, MWQueryable mWQueryable) {
        super((MWQuery)mWReportQuery, mWQueryable);
    }

    MWReportOrderingItem(MWReportQuery mWReportQuery, Iterator iterator) {
        super((MWQuery)mWReportQuery, iterator);
    }

    MWReportOrderingItem(MWReportQuery mWReportQuery, Iterator iterator, Iterator iterator2) {
        super(mWReportQuery, iterator, iterator2);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.ascending = true;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isDesending() {
        return !this.isAscending();
    }

    public void setAscending(boolean bl) {
        boolean bl2 = this.ascending;
        this.ascending = bl;
        this.firePropertyChanged("ascending", bl2, this.ascending);
    }

    public String getItemName() {
        return this.itemName;
    }

    public void removeSelfFromParent() {
        ((MWReportQuery)this.getParentQuery()).removeOrderingItem(this);
    }

    public Problem queryableNullProblem() {
        return this.buildProblem("0252", this.getParentQuery().signature(), new Integer(((MWReportQuery)this.getParentQuery()).indexOfOrderingItem(this) + 1));
    }

    public Problem queryableInvalidProblem(MWQueryable mWQueryable) {
        throw new UnsupportedOperationException();
    }

    public boolean isQueryableValid(MWQueryable mWQueryable) {
        return true;
    }

    protected void adjustRuntimeQuery(ObjectLevelReadQuery objectLevelReadQuery) {
        MWReportAttributeItem mWReportAttributeItem;
        ReportQuery reportQuery = (ReportQuery)objectLevelReadQuery;
        Expression expression = this.getQueryableArgument().runtimeExpression(reportQuery.getExpressionBuilder());
        if (this.itemName != null && (mWReportAttributeItem = this.attributeItem()).getFunction() != "None") {
            expression = mWReportAttributeItem.getFunction() == "Average" ? expression.average() : (mWReportAttributeItem.getFunction() == "Count" ? expression.count() : (mWReportAttributeItem.getFunction() == "Distinct" ? expression.distinct() : (mWReportAttributeItem.getFunction() == "Maximum" ? expression.maximum() : (mWReportAttributeItem.getFunction() == "Minimum" ? expression.minimum() : (mWReportAttributeItem.getFunction() == "Standard Deviation" ? expression.standardDeviation() : (mWReportAttributeItem.getFunction() == "Sum" ? expression.sum() : (mWReportAttributeItem.getFunction() == "Variance" ? expression.variance() : expression.getFunction(mWReportAttributeItem.getFunction()))))))));
        }
        expression = this.isAscending() ? expression.ascending() : expression.descending();
        reportQuery.addOrdering(expression);
    }

    MWReportAttributeItem attributeItem() {
        ListIterator listIterator = ((MWReportQuery)this.getParent()).attributeItems();
        while (listIterator.hasNext()) {
            MWReportAttributeItem mWReportAttributeItem = (MWReportAttributeItem)listIterator.next();
            if (!mWReportAttributeItem.getName().equals(this.itemName)) continue;
            return mWReportAttributeItem;
        }
        return null;
    }

    public String displayString() {
        String string = this.itemName == null ? super.displayString() : this.itemName;
        string = this.isAscending() ? string + " (Ascending)" : string + " (Descending)";
        return string;
    }
}

