/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.resource;

import java.io.IOException;
import java.net.URL;
import org.apache.xerces.util.URI;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ClasspathResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.FileResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.UrlResourceSpecification;

public abstract class ResourceSpecification
extends MWModel {
    protected String location;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(ResourceSpecification.class);
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(FileResourceSpecification.class, (Object)"file");
        inheritancePolicy.addClassIndicator(UrlResourceSpecification.class, (Object)"url");
        inheritancePolicy.addClassIndicator(ClasspathResourceSpecification.class, (Object)"classpath");
        xMLDescriptor.addDirectMapping("location", "getLocationForTopLink", "setLocationForTopLink", "location/text()");
        return xMLDescriptor;
    }

    protected ResourceSpecification() {
    }

    protected ResourceSpecification(MWModel mWModel, String string) {
        super(mWModel);
        this.location = string;
    }

    public String getLocation() {
        return this.location;
    }

    public abstract String getSourceKey();

    public URL validResourceUrl() throws ResourceException {
        URL uRL = this.resourceUrl();
        try {
            uRL.openConnection();
        }
        catch (IOException iOException) {
            throw ResourceException.inaccessibleResourceException(iOException);
        }
        return uRL;
    }

    public URI validResourceURI() throws ResourceException {
        URL uRL = this.validResourceUrl();
        URI uRI = null;
        try {
            uRI = new URI(uRL.toString().replace(" ", "%20"));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw ResourceException.incorrectlySpecifiedResourceException(malformedURIException);
        }
        return uRI;
    }

    protected abstract URL resourceUrl() throws ResourceException;

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.location);
    }

    private String getLocationForTopLink() {
        return this.getLocationForTopLink2();
    }

    protected String getLocationForTopLink2() {
        return this.location;
    }

    private void setLocationForTopLink(String string) {
        this.setLocationForTopLink2(string);
    }

    protected void setLocationForTopLink2(String string) {
        this.location = string;
    }
}

