/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.Content;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.EmptyContent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ExplicitComplexTypeDefinition
extends ExplicitSchemaTypeDefinition
implements MWComplexTypeDefinition {
    private volatile ReferencedSchemaTypeDefinition baseType;
    private volatile String derivationMethod;
    private volatile boolean abstractFlag;
    private Map attributes;
    private volatile Content content;

    protected ExplicitComplexTypeDefinition() {
    }

    ExplicitComplexTypeDefinition(MWModel mWModel, String string) {
        super(mWModel, string);
    }

    ExplicitComplexTypeDefinition(MWModel mWModel, String string, String string2) {
        super(mWModel, string, string2);
    }

    ExplicitComplexTypeDefinition(MWModel mWModel, String string, String string2, boolean bl) {
        super(mWModel, string, string2, bl);
    }

    protected void initialize() {
        super.initialize();
        this.attributes = new Hashtable();
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.baseType = ReferencedSchemaTypeDefinition.urType(this);
        this.content = new EmptyContent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.baseType);
        Map map = this.attributes;
        synchronized (map) {
            list.addAll(this.attributes.values());
        }
        if (this.content != null) {
            list.add(this.content);
        }
    }

    public MWAttributeDeclaration attribute(String string, String string2) {
        Iterator iterator = this.attributes();
        while (iterator.hasNext()) {
            MWAttributeDeclaration mWAttributeDeclaration = (MWAttributeDeclaration)iterator.next();
            if (!string.equals(mWAttributeDeclaration.getNamespaceUrl()) || !string2.equals(mWAttributeDeclaration.getName())) continue;
            return mWAttributeDeclaration;
        }
        return null;
    }

    Iterator attributes() {
        return this.attributes.values().iterator();
    }

    private Iterator attributeNames() {
        return this.attributes.keySet().iterator();
    }

    private void addAttribute(String string, MWAttributeDeclaration mWAttributeDeclaration) {
        this.attributes.put(string, mWAttributeDeclaration);
    }

    private ReferencedAttributeDeclaration addReferencedAttribute(String string, String string2) {
        ReferencedAttributeDeclaration referencedAttributeDeclaration = new ReferencedAttributeDeclaration(this, string, string2);
        this.addAttribute(string, referencedAttributeDeclaration);
        return referencedAttributeDeclaration;
    }

    private ExplicitAttributeDeclaration addExplicitAttribute(String string) {
        ExplicitAttributeDeclaration explicitAttributeDeclaration = new ExplicitAttributeDeclaration(this, string);
        this.addAttribute(string, explicitAttributeDeclaration);
        return explicitAttributeDeclaration;
    }

    private void removeAttribute(String string) {
        MWAttributeDeclaration mWAttributeDeclaration = (MWAttributeDeclaration)this.attributes.remove(string);
        this.getProject().nodeRemoved(mWAttributeDeclaration);
    }

    public String getDerivationMethod() {
        return this.derivationMethod;
    }

    public boolean isAbstract() {
        return this.abstractFlag;
    }

    public int totalElementCount() {
        return this.content.totalElementCount();
    }

    public int attributeCount() {
        return this.attributes.size();
    }

    public MWSchemaTypeDefinition getBaseType() {
        return this.baseType;
    }

    public boolean isComplex() {
        return true;
    }

    public Iterator baseBuiltInTypes() {
        if (this.builtIn) {
            return NullIterator.instance();
        }
        return this.baseType.baseBuiltInTypes();
    }

    public boolean containsText() {
        return this.content.hasTextContent();
    }

    public boolean containsWildcard() {
        return this.content.containsWildcard();
    }

    public int compareSchemaOrder(MWElementDeclaration mWElementDeclaration, MWElementDeclaration mWElementDeclaration2) {
        if (mWElementDeclaration.isDescendantOf(this.baseType)) {
            if (mWElementDeclaration2.isDescendantOf(this.baseType)) {
                return this.baseType.compareSchemaOrder(mWElementDeclaration, mWElementDeclaration2);
            }
            return -1;
        }
        if (mWElementDeclaration2.isDescendantOf(this.baseType)) {
            return 1;
        }
        return this.content.compareSchemaOrder(mWElementDeclaration, mWElementDeclaration2);
    }

    public String componentTypeName() {
        return "complexType";
    }

    public void addDirectlyOwnedComponentsTo(Collection collection) {
        collection.addAll(this.attributes.values());
        this.content.addDirectlyOwnedComponentsTo(collection);
    }

    public Iterator structuralComponents() {
        return new CompositeIterator(this.content.structuralComponents(), this.attributes());
    }

    public Iterator descriptorContextComponents() {
        return this.content.descriptorContextComponents();
    }

    public Iterator xpathComponents() {
        return new CompositeIterator(this.attributes(), this.content.xpathComponents());
    }

    public MWAttributeDeclaration nestedAttribute(String string, String string2) {
        return this.attribute(string, string2);
    }

    public MWElementDeclaration nestedElement(String string, String string2) {
        return this.content.nestedElement(string, string2);
    }

    protected void reloadInternal(XSObject xSObject) {
        super.reloadInternal(xSObject);
        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSObject;
        this.reloadBaseType(xSComplexTypeDecl.getBaseType());
        this.abstractFlag = xSComplexTypeDecl.getAbstract();
        this.derivationMethod = xSComplexTypeDecl.getDerivationMethod() == 2 ? "restriction" : "extension";
        this.reloadContent(xSComplexTypeDecl);
        this.reloadAttributes(xSComplexTypeDecl.getAttributeUses());
    }

    private void reloadBaseType(XSTypeDefinition xSTypeDefinition) {
        ReferencedSchemaTypeDefinition referencedSchemaTypeDefinition = this.baseType;
        String string = null;
        String string2 = null;
        string = xSTypeDefinition.getName();
        string2 = xSTypeDefinition.getNamespace();
        this.baseType = ReferencedSchemaTypeDefinition.reloadedReferencedType(this, referencedSchemaTypeDefinition, string, string2, xSTypeDefinition);
        if (referencedSchemaTypeDefinition != this.baseType && referencedSchemaTypeDefinition != null) {
            this.getProject().nodeRemoved(referencedSchemaTypeDefinition);
        }
    }

    private void reloadContent(XSComplexTypeDecl xSComplexTypeDecl) {
        Content content = this.content;
        this.content = Content.reloadedContent(this, this.content, xSComplexTypeDecl);
        if (content != this.content && content != null) {
            this.getProject().nodeRemoved(content);
        }
    }

    private void reloadAttributes(XSObjectList xSObjectList) {
        Collection collection = CollectionTools.collection(this.attributeNames());
        for (int i = xSObjectList.getLength() - 1; i >= 0; --i) {
            MWAttributeDeclaration mWAttributeDeclaration = this.reloadAttribute((XSAttributeUseImpl)xSObjectList.item(i));
            collection.remove(mWAttributeDeclaration.getName());
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeAttribute((String)iterator.next());
        }
    }

    private MWAttributeDeclaration reloadAttribute(XSAttributeUseImpl xSAttributeUseImpl) {
        String string = xSAttributeUseImpl.getAttrDeclaration().getName();
        MWAttributeDeclaration mWAttributeDeclaration = (MWAttributeDeclaration)this.attributes.get(string);
        if (xSAttributeUseImpl.getAttrDeclaration().getScope() == 1) {
            if (mWAttributeDeclaration == null || !mWAttributeDeclaration.isReference()) {
                mWAttributeDeclaration = this.addReferencedAttribute(string, xSAttributeUseImpl.getAttrDeclaration().getNamespace());
            }
        } else if (mWAttributeDeclaration == null || mWAttributeDeclaration.isReference()) {
            mWAttributeDeclaration = this.addExplicitAttribute(string);
        }
        if (mWAttributeDeclaration.isReference()) {
            mWAttributeDeclaration.reload((XSObject)xSAttributeUseImpl.getAttrDeclaration());
        } else {
            mWAttributeDeclaration.reload((XSObject)xSAttributeUseImpl);
        }
        return mWAttributeDeclaration;
    }

    public void resolveReferences() {
        super.resolveReferences();
        this.baseType.resolveReferences();
        this.content.resolveReferences();
        Iterator iterator = this.attributes.values().iterator();
        while (iterator.hasNext()) {
            ((MWAttributeDeclaration)iterator.next()).resolveReferences();
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(ExplicitComplexTypeDefinition.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(ExplicitSchemaTypeDefinition.class);
        xMLDescriptor.addDirectMapping("abstractFlag", "abstract/text()");
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)"restriction", (Object)"restriction");
        objectTypeConverter.addConversionValue((Object)"extension", (Object)"extension");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("derivationMethod");
        xMLDirectMapping.setXPath("derivation-method/text()");
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("baseType");
        xMLCompositeObjectMapping.setReferenceClass(ReferencedSchemaTypeDefinition.class);
        xMLCompositeObjectMapping.setXPath("base-type");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("attributes");
        xMLCompositeCollectionMapping.setGetMethodName("getAttributesForToplink");
        xMLCompositeCollectionMapping.setSetMethodName("setAttributesForToplink");
        xMLCompositeCollectionMapping.setXPath("attributes/attribute");
        xMLCompositeCollectionMapping.setReferenceClass(AbstractNamedSchemaComponent.class);
        xMLCompositeCollectionMapping.useMapClass(TreeMap.class, "getName");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("content");
        xMLCompositeObjectMapping2.setXPath("content");
        xMLCompositeObjectMapping2.setReferenceClass(Content.class);
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private Map getAttributesForToplink() {
        return new TreeMap(this.attributes);
    }

    private void setAttributesForToplink(Map map) {
        HashMap<String, AbstractNamedSchemaComponent> hashMap = new HashMap<String, AbstractNamedSchemaComponent>();
        for (AbstractNamedSchemaComponent abstractNamedSchemaComponent : map.values()) {
            hashMap.put(abstractNamedSchemaComponent.getName(), abstractNamedSchemaComponent);
        }
        this.attributes = hashMap;
    }
}

