/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.QName;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.IdentityConstraintDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ExplicitElementDeclaration
extends AbstractNamedSchemaComponent
implements MWElementDeclaration {
    private volatile MWSchemaTypeDefinition type;
    private volatile boolean nillable;
    private volatile transient MWAttributeDeclaration nilAttribute;
    private volatile String defaultValue;
    private volatile String fixedValue;
    private Map identityConstraints;
    private volatile ReferencedElementDeclaration substitutionGroup;
    private volatile boolean abstractFlag;
    private volatile int minOccurs;
    private volatile int maxOccurs;

    private ExplicitElementDeclaration() {
    }

    ExplicitElementDeclaration(MWModel mWModel, String string) {
        super(mWModel, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.identityConstraints = new Hashtable();
    }

    protected void initialize() {
        super.initialize();
        this.minOccurs = 1;
        this.maxOccurs = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        if (this.type != null) {
            list.add(this.type);
        }
        Map map = this.identityConstraints;
        synchronized (map) {
            list.addAll(this.identityConstraints.values());
        }
        if (this.substitutionGroup != null) {
            list.add(this.substitutionGroup);
        }
    }

    private MWAttributeDeclaration buildNilAttribute() {
        return new ReferencedAttributeDeclaration(this, "nil", "http://www.w3.org/2001/XMLSchema");
    }

    public MWSchemaTypeDefinition getType() {
        return this.type;
    }

    public MWElementDeclaration getSubstitutionGroup() {
        return this.substitutionGroup;
    }

    public boolean isAbstract() {
        return this.abstractFlag;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public boolean isDescriptorContextComponent() {
        return !this.type.isReference();
    }

    public boolean isEquivalentTo(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.getTerm() instanceof XSElementDecl) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSParticleDecl.getTerm();
            return this.getName().equals(xSElementDecl.getName());
        }
        return false;
    }

    public Iterator baseBuiltInTypes() {
        return this.type.baseBuiltInTypes();
    }

    public boolean hasType() {
        return true;
    }

    public String contextTypeQname() {
        return this.type.contextTypeQname();
    }

    public boolean containsText() {
        return this.type.containsText();
    }

    public boolean containsWildcard() {
        return this.type.containsWildcard();
    }

    public int compareSchemaOrder(MWElementDeclaration mWElementDeclaration, MWElementDeclaration mWElementDeclaration2) {
        return this.type.compareSchemaOrder(mWElementDeclaration, mWElementDeclaration2);
    }

    public String componentTypeName() {
        return "element";
    }

    public void addDirectlyOwnedComponentsTo(Collection collection) {
        this.type.addDirectlyOwnedComponentsTo(collection);
    }

    public Iterator structuralComponents() {
        return this.type.structuralComponents();
    }

    public Iterator descriptorContextComponents() {
        if (!this.type.isReference()) {
            return this.type.descriptorContextComponents();
        }
        return NullIterator.instance();
    }

    public Iterator xpathComponents() {
        Iterator iterator = this.type.xpathComponents();
        if (this.nilAttribute == null) {
            return iterator;
        }
        return new CompositeIterator(this.nilAttribute, this.type.xpathComponents());
    }

    public MWNamedSchemaComponent nestedNamedComponent(QName qName) {
        return this.type.nestedNamedComponent(qName);
    }

    public MWAttributeDeclaration nestedAttribute(String string, String string2) {
        if (this.nilAttribute != null && string.equals(this.nilAttribute.getNamespaceUrl()) && string2.equals(this.nilAttribute.getName())) {
            return this.nilAttribute;
        }
        return this.type.nestedAttribute(string, string2);
    }

    public MWElementDeclaration nestedElement(String string, String string2) {
        return this.type.nestedElement(string, string2);
    }

    public int totalElementCount() {
        return 1;
    }

    protected void reloadInternal(XSObject xSObject) {
        XSElementDecl xSElementDecl = null;
        if (xSObject instanceof XSParticleDecl) {
            xSElementDecl = (XSElementDecl)((XSParticleDecl)xSObject).getTerm();
            super.reloadInternal((XSObject)xSElementDecl);
        } else {
            xSElementDecl = (XSElementDecl)xSObject;
            super.reloadInternal(xSObject);
        }
        this.reloadType(xSElementDecl);
        this.reloadNillable(xSElementDecl);
        if (xSElementDecl.getConstraintType() != 0) {
            if (xSElementDecl.getConstraintType() == 1) {
                this.defaultValue = xSElementDecl.getConstraintValue();
            } else if (xSElementDecl.getConstraintType() == 2) {
                this.fixedValue = xSElementDecl.getConstraintValue();
            }
        }
        this.abstractFlag = xSElementDecl.getAbstract();
        if (xSObject instanceof XSParticleDecl) {
            this.minOccurs = ((XSParticleDecl)xSObject).getMinOccurs();
            this.maxOccurs = ((XSParticleDecl)xSObject).getMaxOccurs();
            if (((XSParticleDecl)xSObject).getMaxOccursUnbounded()) {
                this.maxOccurs = 0x7FFFFFF8;
            }
        }
        this.reloadSubstitutionGroup(xSElementDecl);
        this.reloadIdentityConstraints(xSElementDecl);
    }

    private void reloadType(XSElementDecl xSElementDecl) {
        MWSchemaTypeDefinition mWSchemaTypeDefinition = this.type;
        XSTypeDefinition xSTypeDefinition = xSElementDecl.getTypeDefinition();
        String string = xSTypeDefinition.getName();
        String string2 = xSTypeDefinition.getNamespace();
        this.type = !"".equals(this.getName()) && this.parentNamedComponent() instanceof ExplicitElementDeclaration && this.getName().equals(this.parentNamedComponent().getName()) && this.parentNamedComponent().parentNamedComponent() instanceof ExplicitElementDeclaration && this.getName().equals(this.parentNamedComponent().parentNamedComponent().getName()) ? ReferencedSchemaTypeDefinition.urType(this) : (string == null && (xSTypeDefinition.getTypeCategory() != 15 || ((XSComplexTypeDecl)xSTypeDefinition).getBaseType() != null) ? ExplicitSchemaTypeDefinition.reloadedExplicitType(this, this.type, xSElementDecl) : ReferencedSchemaTypeDefinition.reloadedReferencedType(this, mWSchemaTypeDefinition, string, string2, xSTypeDefinition));
        if (mWSchemaTypeDefinition != this.type && mWSchemaTypeDefinition != null) {
            this.getProject().nodeRemoved(mWSchemaTypeDefinition);
        }
    }

    private void reloadNillable(XSElementDecl xSElementDecl) {
        this.nillable = xSElementDecl.getNillable();
        this.nilAttribute = this.nillable ? this.buildNilAttribute() : null;
    }

    private void reloadSubstitutionGroup(XSElementDecl xSElementDecl) {
        if (xSElementDecl.getSubstitutionGroupAffiliation() != null) {
            String string = xSElementDecl.getSubstitutionGroupAffiliation().getName();
            String string2 = xSElementDecl.getSubstitutionGroupAffiliation().getNamespace();
            this.substitutionGroup = new ReferencedElementDeclaration(this, string, string2);
        } else {
            this.substitutionGroup = null;
        }
    }

    private void reloadIdentityConstraints(XSElementDecl xSElementDecl) {
        IdentityConstraint[] identityConstraintArray = xSElementDecl.getIDConstraints();
        for (int i = 0; identityConstraintArray != null && i < identityConstraintArray.length; ++i) {
            IdentityConstraint identityConstraint = identityConstraintArray[i];
            String string = identityConstraint.getName();
            IdentityConstraintDefinition identityConstraintDefinition = (IdentityConstraintDefinition)this.identityConstraints.get(string);
            if (identityConstraintDefinition == null) {
                identityConstraintDefinition = new IdentityConstraintDefinition(this, string);
                this.identityConstraints.put(string, identityConstraintDefinition);
            }
            identityConstraintDefinition.reload(identityConstraint);
        }
    }

    public void resolveReferences() {
        super.resolveReferences();
        this.type.resolveReferences();
        if (this.nilAttribute != null) {
            this.nilAttribute.resolveReferences();
        }
        if (this.substitutionGroup != null) {
            this.substitutionGroup.resolveReferences();
        }
    }

    private Map getIdentityConstraintsForToplink() {
        return new TreeMap(this.identityConstraints);
    }

    private void setIdentityConstraintsForToplink(Map map) {
        Iterator iterator = map.values().iterator();
        Hashtable<String, IdentityConstraintDefinition> hashtable = new Hashtable<String, IdentityConstraintDefinition>();
        while (iterator.hasNext()) {
            IdentityConstraintDefinition identityConstraintDefinition = (IdentityConstraintDefinition)iterator.next();
            hashtable.put(identityConstraintDefinition.getName(), identityConstraintDefinition);
        }
        this.identityConstraints = hashtable;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(ExplicitElementDeclaration.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(AbstractNamedSchemaComponent.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("type");
        xMLCompositeObjectMapping.setReferenceClass(AbstractSchemaComponent.class);
        xMLCompositeObjectMapping.setXPath("type");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping("nillable", "nillable/text()");
        xMLDirectMapping.setGetMethodName("getNillableForTopLink");
        xMLDirectMapping.setSetMethodName("setNillableForTopLink");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addDirectMapping("defaultValue", "default-value/text()");
        xMLDescriptor.addDirectMapping("fixedValue", "fixed-value/text()");
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("abstractFlag", "abstract/text()");
        xMLDirectMapping2.setNullValue((Object)Boolean.FALSE);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping("minOccurs", "min-occurs/text()")).setNullValue((Object)new Integer(1));
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping("maxOccurs", "max-occurs/text()")).setNullValue((Object)new Integer(1));
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("substitutionGroup");
        xMLCompositeObjectMapping2.setReferenceClass(ReferencedElementDeclaration.class);
        xMLCompositeObjectMapping2.setXPath("substitution-group");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("identityConstraints");
        xMLCompositeCollectionMapping.setGetMethodName("getIdentityConstraintsForToplink");
        xMLCompositeCollectionMapping.setSetMethodName("setIdentityConstraintsForToplink");
        xMLCompositeCollectionMapping.setXPath("identity-constraints/identity-constraint");
        xMLCompositeCollectionMapping.setReferenceClass(IdentityConstraintDefinition.class);
        xMLCompositeCollectionMapping.useMapClass(TreeMap.class, "getName");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private boolean getNillableForTopLink() {
        return this.nillable;
    }

    private void setNillableForTopLink(boolean bl) {
        this.nillable = bl;
        if (bl) {
            this.nilAttribute = this.buildNilAttribute();
        }
    }
}

