/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.opti.SchemaDOM;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWXmlProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroup;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ModelGroupDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWNamespace
extends MWModel {
    public static final Comparator COMPARATOR = new NamespaceComparator();
    private String namespaceUrl;
    public static final String NAMESPACE_URL_PROPERTY = "namespaceUrl";
    private String namespacePrefix;
    public static final String NAMESPACE_PREFIX_PROPERTY = "namespacePrefix";
    private boolean namespacePrefixIsUserDefined;
    public static final String NAME_XML_NAMESPACE_URL = "http://www.w3.org/XML/1998/namespace";
    private boolean declared;
    public static final String DECLARED_PROPERTY = "declared";
    private Map attributeDeclarations;
    private Map elementDeclarations;
    private Map typeDefinitions;
    private Map modelGroupDefinitions;

    static MWNamespace xsdNamespace(MWXmlSchema mWXmlSchema) {
        MWNamespace mWNamespace = new MWNamespace(mWXmlSchema);
        mWNamespace.namespaceUrl = "http://www.w3.org/2001/XMLSchema";
        mWNamespace.namespacePrefix = "xsd";
        mWNamespace.addBuiltInComplexType("anyType");
        mWNamespace.addBuiltInSimpleType("anySimpleType");
        mWNamespace.addBuiltInSimpleType("duration");
        mWNamespace.addBuiltInSimpleType("date");
        mWNamespace.addBuiltInSimpleType("time");
        mWNamespace.addBuiltInSimpleType("dateTime");
        mWNamespace.addBuiltInSimpleType("gDay");
        mWNamespace.addBuiltInSimpleType("gMonth");
        mWNamespace.addBuiltInSimpleType("gYear");
        mWNamespace.addBuiltInSimpleType("gMonthDay");
        mWNamespace.addBuiltInSimpleType("gYearMonth");
        mWNamespace.addBuiltInSimpleType("string");
        mWNamespace.addBuiltInSimpleType("normalizedString");
        mWNamespace.addBuiltInSimpleType("token");
        mWNamespace.addBuiltInSimpleType("language");
        mWNamespace.addBuiltInSimpleType("Name");
        mWNamespace.addBuiltInSimpleType("NMTOKEN");
        mWNamespace.addBuiltInSimpleType("NMTOKENS");
        mWNamespace.addBuiltInSimpleType("NCName");
        mWNamespace.addBuiltInSimpleType("ID");
        mWNamespace.addBuiltInSimpleType("IDREF");
        mWNamespace.addBuiltInSimpleType("IDREFS");
        mWNamespace.addBuiltInSimpleType("ENTITY");
        mWNamespace.addBuiltInSimpleType("ENTITIES");
        mWNamespace.addBuiltInSimpleType("boolean");
        mWNamespace.addBuiltInSimpleType("base64Binary");
        mWNamespace.addBuiltInSimpleType("hexBinary");
        mWNamespace.addBuiltInSimpleType("float");
        mWNamespace.addBuiltInSimpleType("double");
        mWNamespace.addBuiltInSimpleType("decimal");
        mWNamespace.addBuiltInSimpleType("integer");
        mWNamespace.addBuiltInSimpleType("nonPositiveInteger");
        mWNamespace.addBuiltInSimpleType("long");
        mWNamespace.addBuiltInSimpleType("nonNegativeInteger");
        mWNamespace.addBuiltInSimpleType("negativeInteger");
        mWNamespace.addBuiltInSimpleType("int");
        mWNamespace.addBuiltInSimpleType("short");
        mWNamespace.addBuiltInSimpleType("byte");
        mWNamespace.addBuiltInSimpleType("positiveInteger");
        mWNamespace.addBuiltInSimpleType("unsignedLong");
        mWNamespace.addBuiltInSimpleType("unsignedInt");
        mWNamespace.addBuiltInSimpleType("unsignedShort");
        mWNamespace.addBuiltInSimpleType("unsignedByte");
        mWNamespace.addBuiltInSimpleType("anyURI");
        mWNamespace.addBuiltInSimpleType("QName");
        mWNamespace.addBuiltInSimpleType("NOTATION");
        return mWNamespace;
    }

    static MWNamespace xsiNamespace(MWXmlSchema mWXmlSchema) {
        MWNamespace mWNamespace = new MWNamespace(mWXmlSchema);
        mWNamespace.namespaceUrl = "http://www.w3.org/2001/XMLSchema-instance";
        mWNamespace.namespacePrefix = "xsi";
        mWNamespace.addAttribute("nil");
        mWNamespace.addAttribute("type");
        mWNamespace.addAttribute("schemaLocation");
        mWNamespace.addAttribute("noNamespaceSchemaLocation");
        return mWNamespace;
    }

    protected MWNamespace() {
    }

    MWNamespace(MWXmlSchema mWXmlSchema) {
        super(mWXmlSchema);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWNamespace.class);
        xMLDescriptor.setDefaultRootElement("namespace");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setNullValue((Object)"");
        xMLDirectMapping.setAttributeName(NAMESPACE_PREFIX_PROPERTY);
        xMLDirectMapping.setXPath("namespace-prefix/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        xMLDescriptor.addDirectMapping("namespacePrefixIsUserDefined", "namespace-prefix-is-user-defined/text()");
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setNullValue((Object)"");
        xMLDirectMapping2.setAttributeName(NAMESPACE_URL_PROPERTY);
        xMLDirectMapping2.setXPath("namespace-url/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        xMLDescriptor.addDirectMapping(DECLARED_PROPERTY, "getDeclaredForTopLink", "setDeclaredForTopLink", "declared/text()");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("attributeDeclarations");
        xMLCompositeCollectionMapping.setGetMethodName("getAttributeDeclarationsForToplink");
        xMLCompositeCollectionMapping.setSetMethodName("setAttributeDeclarationsForToplink");
        xMLCompositeCollectionMapping.setXPath("attribute-declarations/attribute-declaration");
        xMLCompositeCollectionMapping.setReferenceClass(ExplicitAttributeDeclaration.class);
        xMLCompositeCollectionMapping.useMapClass(TreeMap.class, "getName");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName("elementDeclarations");
        xMLCompositeCollectionMapping2.setGetMethodName("getElementDeclarationsForToplink");
        xMLCompositeCollectionMapping2.setSetMethodName("setElementDeclarationsForToplink");
        xMLCompositeCollectionMapping2.setXPath("element-declarations/element-declaration");
        xMLCompositeCollectionMapping2.setReferenceClass(ExplicitElementDeclaration.class);
        xMLCompositeCollectionMapping2.useMapClass(TreeMap.class, "getName");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping3 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping3.setAttributeName("typeDefinitions");
        xMLCompositeCollectionMapping3.setGetMethodName("getTypeDefinitionsForToplink");
        xMLCompositeCollectionMapping3.setSetMethodName("setTypeDefinitionsForToplink");
        xMLCompositeCollectionMapping3.setXPath("type-definitions/type-definition");
        xMLCompositeCollectionMapping3.setReferenceClass(ExplicitSchemaTypeDefinition.class);
        xMLCompositeCollectionMapping3.useMapClass(TreeMap.class, "getName");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping3);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping4 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping4.setAttributeName("modelGroupDefinitions");
        xMLCompositeCollectionMapping4.setGetMethodName("getModelGroupDefinitionsForToplink");
        xMLCompositeCollectionMapping4.setSetMethodName("setModelGroupDefinitionsForToplink");
        xMLCompositeCollectionMapping4.setXPath("model-group-definitions/model-group-definition");
        xMLCompositeCollectionMapping4.setReferenceClass(ModelGroupDefinition.class);
        xMLCompositeCollectionMapping4.useMapClass(TreeMap.class, "getName");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping4);
        return xMLDescriptor;
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.namespacePrefix = "";
        this.namespaceUrl = "";
        this.attributeDeclarations = new Hashtable();
        this.elementDeclarations = new Hashtable();
        this.typeDefinitions = new Hashtable();
        this.modelGroupDefinitions = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Map map = this.attributeDeclarations;
        synchronized (map) {
            list.addAll(this.attributeDeclarations.values());
        }
        map = this.elementDeclarations;
        synchronized (map) {
            list.addAll(this.elementDeclarations.values());
        }
        map = this.typeDefinitions;
        synchronized (map) {
            list.addAll(this.typeDefinitions.values());
        }
        map = this.modelGroupDefinitions;
        synchronized (map) {
            list.addAll(this.modelGroupDefinitions.values());
        }
    }

    public String getNamespaceUrl() {
        return this.namespaceUrl;
    }

    public String getNamespaceUrlForDisplay() {
        String string = this.getNamespaceUrl();
        if (string == null || string.equals("")) {
            return "(absent)";
        }
        return string;
    }

    private void setNamespaceUrl(String string) {
        String string2 = this.namespaceUrl;
        this.namespaceUrl = string;
        this.firePropertyChanged(NAMESPACE_URL_PROPERTY, string2, string);
        if (NAME_XML_NAMESPACE_URL.equals(string)) {
            this.setNamespacePrefix("xml");
            this.namespacePrefixIsUserDefined = false;
        }
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefixFromUser(String string) {
        this.setNamespacePrefix(string);
        this.setNamespacePrefixIsUserDefined(true);
    }

    public void setNamespacePrefixFromSchemaDoc(String string) {
        if (this.namespacePrefixIsUserDefined()) {
            return;
        }
        this.setNamespacePrefix(string);
        if (!this.isBuiltInNamespace()) {
            this.setDeclared(true);
        }
    }

    private void setNamespacePrefix(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = this.namespacePrefix;
        this.namespacePrefix = string;
        this.firePropertyChanged(NAMESPACE_PREFIX_PROPERTY, string2, string);
        ((MWXmlProject)this.getProject()).schemaChanged(SchemaChange.namespacePrefixesChanged(this.getSchema()));
    }

    public boolean namespacePrefixIsUserDefined() {
        return this.namespacePrefixIsUserDefined;
    }

    public void setNamespacePrefixIsUserDefined(boolean bl) {
        this.namespacePrefixIsUserDefined = bl;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public void setDeclared(boolean bl) {
        boolean bl2 = this.declared;
        this.declared = bl;
        this.firePropertyChanged(DECLARED_PROPERTY, bl2, bl);
    }

    public Iterator attributes() {
        return this.attributeDeclarations.values().iterator();
    }

    public int attributeCount() {
        return this.attributeDeclarations.size();
    }

    public Iterator elements() {
        return this.elementDeclarations.values().iterator();
    }

    public int elementCount() {
        return this.elementDeclarations.size();
    }

    public Iterator complexTypes() {
        ArrayList<MWSchemaTypeDefinition> arrayList = new ArrayList<MWSchemaTypeDefinition>();
        Iterator iterator = this.types();
        while (iterator.hasNext()) {
            MWSchemaTypeDefinition mWSchemaTypeDefinition = (MWSchemaTypeDefinition)iterator.next();
            if (!mWSchemaTypeDefinition.isComplex()) continue;
            arrayList.add(mWSchemaTypeDefinition);
        }
        return arrayList.iterator();
    }

    public Iterator simpleTypes() {
        ArrayList<MWSchemaTypeDefinition> arrayList = new ArrayList<MWSchemaTypeDefinition>();
        Iterator iterator = this.types();
        while (iterator.hasNext()) {
            MWSchemaTypeDefinition mWSchemaTypeDefinition = (MWSchemaTypeDefinition)iterator.next();
            if (mWSchemaTypeDefinition.isComplex()) continue;
            arrayList.add(mWSchemaTypeDefinition);
        }
        return arrayList.iterator();
    }

    public Iterator types() {
        return this.typeDefinitions.values().iterator();
    }

    public int typeCount() {
        return this.typeDefinitions.size();
    }

    public Iterator modelGroupDefinitions() {
        return this.modelGroupDefinitions.values().iterator();
    }

    public int modelGroupDefinitionsCount() {
        return this.modelGroupDefinitions.size();
    }

    private ExplicitSimpleTypeDefinition addBuiltInSimpleType(String string) {
        ExplicitSimpleTypeDefinition explicitSimpleTypeDefinition = new ExplicitSimpleTypeDefinition(this, string, this.namespaceUrl, true);
        this.typeDefinitions.put(string, explicitSimpleTypeDefinition);
        return explicitSimpleTypeDefinition;
    }

    private ExplicitSimpleTypeDefinition addSimpleType(String string) {
        ExplicitSimpleTypeDefinition explicitSimpleTypeDefinition = new ExplicitSimpleTypeDefinition(this, string, this.namespaceUrl);
        this.typeDefinitions.put(string, explicitSimpleTypeDefinition);
        return explicitSimpleTypeDefinition;
    }

    private ExplicitComplexTypeDefinition addBuiltInComplexType(String string) {
        ExplicitComplexTypeDefinition explicitComplexTypeDefinition = new ExplicitComplexTypeDefinition(this, string, this.namespaceUrl, true);
        this.typeDefinitions.put(string, explicitComplexTypeDefinition);
        return explicitComplexTypeDefinition;
    }

    private ExplicitComplexTypeDefinition addComplexType(String string) {
        ExplicitComplexTypeDefinition explicitComplexTypeDefinition = new ExplicitComplexTypeDefinition(this, string, this.namespaceUrl);
        this.typeDefinitions.put(string, explicitComplexTypeDefinition);
        return explicitComplexTypeDefinition;
    }

    private void removeType(String string) {
        ExplicitSchemaTypeDefinition explicitSchemaTypeDefinition = (ExplicitSchemaTypeDefinition)this.typeDefinitions.remove(string);
        this.getProject().nodeRemoved(explicitSchemaTypeDefinition);
    }

    private ExplicitAttributeDeclaration addAttribute(String string) {
        ExplicitAttributeDeclaration explicitAttributeDeclaration = new ExplicitAttributeDeclaration(this, string);
        this.attributeDeclarations.put(string, explicitAttributeDeclaration);
        return explicitAttributeDeclaration;
    }

    private void removeAttribute(ExplicitAttributeDeclaration explicitAttributeDeclaration) {
        this.attributeDeclarations.remove(explicitAttributeDeclaration.getName());
        this.getProject().nodeRemoved(explicitAttributeDeclaration);
    }

    private ExplicitElementDeclaration addElement(String string) {
        ExplicitElementDeclaration explicitElementDeclaration = new ExplicitElementDeclaration(this, string);
        this.elementDeclarations.put(string, explicitElementDeclaration);
        return explicitElementDeclaration;
    }

    private void removeElement(ExplicitElementDeclaration explicitElementDeclaration) {
        this.elementDeclarations.remove(explicitElementDeclaration.getName());
        this.getProject().nodeRemoved(explicitElementDeclaration);
    }

    private ModelGroupDefinition addGroup(String string) {
        ModelGroupDefinition modelGroupDefinition = new ModelGroupDefinition(this, string);
        this.modelGroupDefinitions.put(string, modelGroupDefinition);
        return modelGroupDefinition;
    }

    private void removeGroup(ModelGroupDefinition modelGroupDefinition) {
        this.modelGroupDefinitions.remove(modelGroupDefinition.getName());
        this.getProject().nodeRemoved(modelGroupDefinition);
    }

    public MWAttributeDeclaration attribute(String string) {
        return (ExplicitAttributeDeclaration)this.attributeDeclarations.get(string);
    }

    public MWElementDeclaration element(String string) {
        if (string != null) {
            return (ExplicitElementDeclaration)this.elementDeclarations.get(string);
        }
        return null;
    }

    public MWComplexTypeDefinition complexType(String string) {
        return (ExplicitComplexTypeDefinition)this.typeDefinitions.get(string);
    }

    public MWSimpleTypeDefinition simpleType(String string) {
        return (ExplicitSimpleTypeDefinition)this.typeDefinitions.get(string);
    }

    ModelGroupDefinition modelGroupDefinition(String string) {
        return (ModelGroupDefinition)this.modelGroupDefinitions.get(string);
    }

    public MWModelGroup modelGroup(String string) {
        return this.modelGroupDefinition(string).getModelGroup();
    }

    public Iterator structuralComponents() {
        return new CompositeIterator(new Iterator[]{this.elements(), this.modelGroupDefinitions(), this.attributes(), this.types()});
    }

    public int structuralComponentCount() {
        return this.elementCount() + this.modelGroupDefinitionsCount() + this.attributeCount() + this.typeCount();
    }

    public Iterator contextComponents() {
        return new CompositeIterator(new Iterator[]{this.elements(), this.types(), this.modelGroupDefinitions()});
    }

    public boolean isTargetNamespace() {
        return this.getSchema().targetNamespace() == this;
    }

    public boolean isBuiltInNamespace() {
        return CollectionTools.contains(this.getSchema().builtInNamespaces(), (Object)this);
    }

    public MWXmlSchema getSchema() {
        return (MWXmlSchema)this.getParent();
    }

    public void reload(XSModel xSModel, SchemaDOM schemaDOM, String string) {
        this.setNamespaceUrl(string);
        this.reloadTypes(xSModel.getComponents((short)3));
        this.reloadAttributes(xSModel.getComponents((short)1));
        this.reloadElements(xSModel.getComponents((short)2));
        this.reloadGroups(xSModel.getComponents((short)6));
        if ("".equals(this.namespaceUrl)) {
            this.setNamespacePrefix("");
            this.namespacePrefixIsUserDefined = false;
        }
    }

    private void reloadTypes(XSNamedMap xSNamedMap) {
        Collection collection = CollectionTools.collection(this.typeDefinitions.keySet().iterator());
        for (int i = xSNamedMap.getLength() - 1; i >= 0; --i) {
            XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)xSNamedMap.item(i);
            ExplicitSchemaTypeDefinition explicitSchemaTypeDefinition = null;
            String string = xSTypeDefinition.getNamespace();
            if (string == null) {
                string = "";
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(xSTypeDefinition.getNamespace()) || !string.equals(this.getNamespaceUrl())) continue;
            explicitSchemaTypeDefinition = xSTypeDefinition.getTypeCategory() == 16 ? this.reloadSimpleType((XSSimpleTypeDecl)xSTypeDefinition) : this.reloadComplexType((XSComplexTypeDecl)xSTypeDefinition);
            collection.remove(explicitSchemaTypeDefinition.getName());
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeType((String)iterator.next());
        }
    }

    private ExplicitSimpleTypeDefinition reloadSimpleType(XSSimpleTypeDecl xSSimpleTypeDecl) {
        ExplicitSimpleTypeDefinition explicitSimpleTypeDefinition;
        String string = xSSimpleTypeDecl.getName();
        ExplicitSchemaTypeDefinition explicitSchemaTypeDefinition = (ExplicitSchemaTypeDefinition)this.typeDefinitions.get(string);
        try {
            explicitSimpleTypeDefinition = (ExplicitSimpleTypeDefinition)explicitSchemaTypeDefinition;
        }
        catch (ClassCastException classCastException) {
            explicitSimpleTypeDefinition = null;
        }
        if (explicitSimpleTypeDefinition == null) {
            explicitSimpleTypeDefinition = this.addSimpleType(string);
        }
        explicitSimpleTypeDefinition.reload((XSObject)xSSimpleTypeDecl);
        return explicitSimpleTypeDefinition;
    }

    private ExplicitComplexTypeDefinition reloadComplexType(XSComplexTypeDecl xSComplexTypeDecl) {
        ExplicitComplexTypeDefinition explicitComplexTypeDefinition;
        String string = xSComplexTypeDecl.getName();
        ExplicitSchemaTypeDefinition explicitSchemaTypeDefinition = (ExplicitSchemaTypeDefinition)this.typeDefinitions.get(string);
        try {
            explicitComplexTypeDefinition = (ExplicitComplexTypeDefinition)explicitSchemaTypeDefinition;
        }
        catch (ClassCastException classCastException) {
            explicitComplexTypeDefinition = null;
        }
        if (explicitComplexTypeDefinition == null) {
            explicitComplexTypeDefinition = this.addComplexType(string);
        }
        explicitComplexTypeDefinition.reload((XSObject)xSComplexTypeDecl);
        return explicitComplexTypeDefinition;
    }

    private void reloadAttributes(XSNamedMap xSNamedMap) {
        HashBag hashBag = new HashBag(this.attributeDeclarations.values());
        for (int i = xSNamedMap.getLength() - 1; i >= 0; --i) {
            XSAttributeDecl xSAttributeDecl = (XSAttributeDecl)xSNamedMap.item(i);
            String string = xSAttributeDecl.getNamespace();
            if (string == null) {
                string = "";
            }
            if (!string.equals(this.getNamespaceUrl())) continue;
            ExplicitAttributeDeclaration explicitAttributeDeclaration = this.reloadAttribute(xSAttributeDecl);
            hashBag.remove(explicitAttributeDeclaration);
        }
        Iterator iterator = hashBag.iterator();
        while (iterator.hasNext()) {
            this.removeAttribute((ExplicitAttributeDeclaration)iterator.next());
        }
    }

    private ExplicitAttributeDeclaration reloadAttribute(XSAttributeDecl xSAttributeDecl) {
        String string = xSAttributeDecl.getName();
        ExplicitAttributeDeclaration explicitAttributeDeclaration = (ExplicitAttributeDeclaration)this.attributeDeclarations.get(string);
        if (explicitAttributeDeclaration == null) {
            explicitAttributeDeclaration = this.addAttribute(string);
        }
        explicitAttributeDeclaration.reload((XSObject)xSAttributeDecl);
        return explicitAttributeDeclaration;
    }

    private void reloadElements(XSNamedMap xSNamedMap) {
        HashBag hashBag = new HashBag(this.elementDeclarations.values());
        for (int i = xSNamedMap.getLength() - 1; i >= 0; --i) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSNamedMap.item(i);
            String string = xSElementDecl.getNamespace();
            if (string == null) {
                string = "";
            }
            if (!string.equals(this.getNamespaceUrl())) continue;
            ExplicitElementDeclaration explicitElementDeclaration = this.reloadElement(xSElementDecl);
            hashBag.remove(explicitElementDeclaration);
        }
        Iterator iterator = hashBag.iterator();
        while (iterator.hasNext()) {
            this.removeElement((ExplicitElementDeclaration)iterator.next());
        }
    }

    private ExplicitElementDeclaration reloadElement(XSElementDecl xSElementDecl) {
        String string = xSElementDecl.getName();
        ExplicitElementDeclaration explicitElementDeclaration = (ExplicitElementDeclaration)this.elementDeclarations.get(string);
        if (explicitElementDeclaration == null) {
            explicitElementDeclaration = this.addElement(string);
        }
        explicitElementDeclaration.reload((XSObject)xSElementDecl);
        return explicitElementDeclaration;
    }

    private void reloadGroups(XSNamedMap xSNamedMap) {
        HashBag hashBag = new HashBag(this.modelGroupDefinitions.values());
        for (int i = xSNamedMap.getLength() - 1; i >= 0; --i) {
            XSModelGroupDefinition xSModelGroupDefinition = (XSModelGroupDefinition)xSNamedMap.item(i);
            String string = xSModelGroupDefinition.getNamespace();
            if (string == null) {
                string = "";
            }
            if (!string.equals(this.getNamespaceUrl())) continue;
            ModelGroupDefinition modelGroupDefinition = this.reloadGroup(xSModelGroupDefinition);
            hashBag.remove(modelGroupDefinition);
        }
        Iterator iterator = hashBag.iterator();
        while (iterator.hasNext()) {
            this.removeGroup((ModelGroupDefinition)iterator.next());
        }
    }

    private ModelGroupDefinition reloadGroup(XSModelGroupDefinition xSModelGroupDefinition) {
        String string = xSModelGroupDefinition.getName();
        ModelGroupDefinition modelGroupDefinition = (ModelGroupDefinition)this.modelGroupDefinitions.get(string);
        if (modelGroupDefinition == null) {
            modelGroupDefinition = this.addGroup(string);
        }
        modelGroupDefinition.reload((XSObject)xSModelGroupDefinition);
        return modelGroupDefinition;
    }

    public void resolveReferences() {
        Iterator iterator = this.types();
        while (iterator.hasNext()) {
            ((ExplicitSchemaTypeDefinition)iterator.next()).resolveReferences();
        }
        iterator = this.attributes();
        while (iterator.hasNext()) {
            ((ExplicitAttributeDeclaration)iterator.next()).resolveReferences();
        }
        iterator = this.elements();
        while (iterator.hasNext()) {
            ((ExplicitElementDeclaration)iterator.next()).resolveReferences();
        }
        iterator = this.modelGroupDefinitions();
        while (iterator.hasNext()) {
            ((ModelGroupDefinition)iterator.next()).resolveReferences();
        }
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        String string = this.getNamespaceUrl().equals("") ? "(absent)" : this.getNamespaceUrl();
        stringBuffer.append("namespace: " + string);
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        return this.getNamespaceUrl().compareTo(((MWNamespace)object).getNamespaceUrl());
    }

    private Boolean getDeclaredForTopLink() {
        return new Boolean(this.declared);
    }

    private void setDeclaredForTopLink(Boolean bl) {
        if (bl == null) {
            bl = Boolean.TRUE;
        }
        this.declared = bl;
    }

    private Map getAttributeDeclarationsForToplink() {
        return new TreeMap(this.attributeDeclarations);
    }

    private void setAttributeDeclarationsForToplink(Map map) {
        this.attributeDeclarations = this.mapFromNamedElements(map.values().iterator());
    }

    private Map getElementDeclarationsForToplink() {
        return new TreeMap(this.elementDeclarations);
    }

    private void setElementDeclarationsForToplink(Map map) {
        this.elementDeclarations = this.mapFromNamedElements(map.values().iterator());
    }

    private Map getTypeDefinitionsForToplink() {
        return new TreeMap(this.typeDefinitions);
    }

    private void setTypeDefinitionsForToplink(Map map) {
        this.typeDefinitions = this.mapFromNamedElements(map.values().iterator());
    }

    private Map getModelGroupDefinitionsForToplink() {
        return new TreeMap(this.modelGroupDefinitions);
    }

    private void setModelGroupDefinitionsForToplink(Map map) {
        this.modelGroupDefinitions = this.mapFromNamedElements(map.values().iterator());
    }

    private Map mapFromNamedElements(Iterator iterator) {
        Hashtable<String, MWNamedSchemaComponent> hashtable = new Hashtable<String, MWNamedSchemaComponent>();
        while (iterator.hasNext()) {
            MWNamedSchemaComponent mWNamedSchemaComponent = (MWNamedSchemaComponent)iterator.next();
            hashtable.put(mWNamedSchemaComponent.getName(), mWNamedSchemaComponent);
        }
        return hashtable;
    }

    public void setNamespacePrefixFromSchemaDocForTopLink(String string) {
        if (this.namespacePrefixIsUserDefined()) {
            return;
        }
        this.namespacePrefix = string;
    }

    public void setNamespaceIsDeclaredFromSchemaDocForTopLink(boolean bl) {
        this.declared = bl;
    }

    private static class NamespaceComparator
    implements Comparator {
        NamespaceComparator() {
        }

        public int compare(Object object, Object object2) {
            return this.compare((MWNamespace)object, (MWNamespace)object2);
        }

        public int compare(MWNamespace mWNamespace, MWNamespace mWNamespace2) {
            if ("http://www.w3.org/2001/XMLSchema".equals(mWNamespace.getNamespaceUrl())) {
                return -1;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(mWNamespace2.getNamespaceUrl())) {
                return 1;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(mWNamespace.getNamespaceUrl())) {
                return -1;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(mWNamespace2.getNamespaceUrl())) {
                return 1;
            }
            if (mWNamespace.isTargetNamespace()) {
                return -1;
            }
            if (mWNamespace2.isTargetNamespace()) {
                return 1;
            }
            return Collator.getInstance().compare(mWNamespace.getNamespaceUrl(), mWNamespace2.getNamespaceUrl());
        }
    }
}

