/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalTableDescription;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class JDBCExternalForeignKey
implements ExternalForeignKey {
    private final JDBCExternalTable table;
    private final String name;
    private final ExternalTableDescription targetTableDescription;
    private ExternalForeignKeyColumnPair[] columnPairs;

    JDBCExternalForeignKey(JDBCExternalTable jDBCExternalTable, String string, ResultSet resultSet) {
        this.table = jDBCExternalTable;
        this.name = string;
        this.targetTableDescription = new JDBCExternalTableDescription(this.stringFrom(resultSet, 1), this.stringFrom(resultSet, 2), this.stringFrom(resultSet, 3), this.database());
    }

    private String stringFrom(ResultSet resultSet, int n) {
        try {
            return this.trim(resultSet.getString(n));
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private String trim(String string) {
        if (string == null) {
            return null;
        }
        return (string = string.trim()).length() == 0 ? null : string;
    }

    public String getName() {
        return this.name;
    }

    public ExternalForeignKeyColumnPair[] getColumnPairs() {
        return this.columnPairs;
    }

    public ExternalTableDescription getTargetTableDescription() {
        return this.targetTableDescription;
    }

    void addColumnPair(ResultSet resultSet) {
        int n = this.columnPairs == null ? 0 : this.columnPairs.length;
        JDBCExternalForeignKeyColumnPair[] jDBCExternalForeignKeyColumnPairArray = new JDBCExternalForeignKeyColumnPair[n + 1];
        if (n != 0) {
            System.arraycopy(this.columnPairs, 0, jDBCExternalForeignKeyColumnPairArray, 0, n);
        }
        jDBCExternalForeignKeyColumnPairArray[n] = new JDBCExternalForeignKeyColumnPair(this, resultSet);
        this.columnPairs = jDBCExternalForeignKeyColumnPairArray;
    }

    JDBCExternalColumn columnNamed(String string) {
        return this.table.columnNamed(string);
    }

    private JDBCExternalDatabase database() {
        return this.table.database();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.name);
    }
}

