/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalTable;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class JDBCExternalTableDescription
implements ExternalTableDescription {
    private final JDBCExternalDatabase database;
    private final String catalogName;
    private final String schemaName;
    private final String name;
    private final String qualifiedName;
    private ExternalTable externalTable;

    JDBCExternalTableDescription(ResultSet resultSet, JDBCExternalDatabase jDBCExternalDatabase) throws SQLException {
        this(JDBCExternalTableDescription.trim(resultSet.getString(1)), JDBCExternalTableDescription.trim(resultSet.getString(2)), JDBCExternalTableDescription.trim(resultSet.getString(3)), jDBCExternalDatabase);
    }

    JDBCExternalTableDescription(String string, String string2, String string3, JDBCExternalDatabase jDBCExternalDatabase) {
        this.catalogName = string;
        this.schemaName = string2;
        this.name = string3;
        this.qualifiedName = this.buildQualifiedName();
        this.database = jDBCExternalDatabase;
    }

    private static String trim(String string) {
        if (string == null) {
            return null;
        }
        return (string = string.trim()).length() == 0 ? null : string;
    }

    private String buildQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName(this.catalogName, this.schemaName, this.name);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public ExternalTable getTable() {
        if (this.externalTable == null) {
            this.externalTable = this.buildExternalTable();
        }
        return this.externalTable;
    }

    public String getAdditionalInfo() {
        try {
            return this.metaData().getURL();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private ExternalTable buildExternalTable() {
        try {
            return new JDBCExternalTable(this);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    DatabaseMetaData metaData() {
        return this.database.metaData();
    }

    JDBCExternalDatabase getDatabase() {
        return this.database;
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.qualifiedName);
    }
}

