/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile;

import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalMethod;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.Field;
import org.eclipse.persistence.tools.workbench.utility.classfile.Method;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class CFExternalClass
implements ExternalClass {
    private final ClassFile classFile;
    private final CFExternalClassDescription classDescription;

    CFExternalClass(ClassFile classFile, CFExternalClassDescription cFExternalClassDescription) {
        this.classFile = classFile;
        this.classDescription = cFExternalClassDescription;
    }

    public ExternalClassDescription[] getDeclaredClasses() {
        return this.buildClassDescriptionArray(this.classFile.declaredMemberClassNames());
    }

    public ExternalConstructor[] getDeclaredConstructors() {
        return this.buildConstructorArray(this.classFile.getMethodPool().declaredConstructors());
    }

    public ExternalField[] getDeclaredFields() {
        return this.buildFieldArray(this.classFile.getFieldPool().declaredFields());
    }

    public ExternalMethod[] getDeclaredMethods() {
        return this.buildMethodArray(this.classFile.getMethodPool().declaredMethods());
    }

    public ExternalClassDescription getDeclaringClass() {
        return this.classDescriptionNamed(this.classFile.declaringClassName());
    }

    public ExternalClassDescription[] getInterfaces() {
        return this.buildClassDescriptionArray(this.classFile.interfaceNames());
    }

    public int getModifiers() {
        return this.classFile.standardAccessFlags();
    }

    public String getName() {
        return this.classFile.className();
    }

    public ExternalClassDescription getSuperclass() {
        return this.classDescriptionNamed(this.classFile.superClassName());
    }

    public boolean isInterface() {
        return this.classFile.isInterface();
    }

    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.getName());
    }

    ExternalClassDescription classDescriptionNamed(String string) {
        if (string == null) {
            return null;
        }
        return this.classDescription.classDescriptionNamed(string);
    }

    private ExternalClassDescription[] buildClassDescriptionArray(String[] stringArray) {
        ExternalClassDescription[] externalClassDescriptionArray = new ExternalClassDescription[stringArray.length];
        int n = stringArray.length;
        while (n-- > 0) {
            externalClassDescriptionArray[n] = this.classDescriptionNamed(stringArray[n]);
        }
        return externalClassDescriptionArray;
    }

    private ExternalConstructor[] buildConstructorArray(Method[] methodArray) {
        ExternalConstructor[] externalConstructorArray = new ExternalConstructor[methodArray.length];
        int n = methodArray.length;
        while (n-- > 0) {
            externalConstructorArray[n] = new CFExternalConstructor(methodArray[n], this);
        }
        return externalConstructorArray;
    }

    private ExternalField[] buildFieldArray(Field[] fieldArray) {
        ExternalField[] externalFieldArray = new ExternalField[fieldArray.length];
        int n = fieldArray.length;
        while (n-- > 0) {
            externalFieldArray[n] = new CFExternalField(fieldArray[n], this);
        }
        return externalFieldArray;
    }

    private ExternalMethod[] buildMethodArray(Method[] methodArray) {
        ExternalMethod[] externalMethodArray = new ExternalMethod[methodArray.length];
        int n = methodArray.length;
        while (n-- > 0) {
            externalMethodArray[n] = new CFExternalMethod(methodArray[n], this);
        }
        return externalMethodArray;
    }
}

