/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalClassDescription;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

abstract class AbstractCLExternalClassRepository
implements ExternalClassRepository {
    private Map classDescriptions;
    private ClassLoader classLoader;
    private final Map arrayClassDescriptions = new HashMap();

    AbstractCLExternalClassRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalClassDescription getClassDescription(String string) {
        AbstractCLExternalClassRepository abstractCLExternalClassRepository = this;
        synchronized (abstractCLExternalClassRepository) {
            if (this.classDescriptions == null) {
                this.classDescriptions = this.buildClassDescriptions();
            }
        }
        return (ExternalClassDescription)this.classDescriptions.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalClassDescription[] getClassDescriptions() {
        AbstractCLExternalClassRepository abstractCLExternalClassRepository = this;
        synchronized (abstractCLExternalClassRepository) {
            if (this.classDescriptions == null) {
                this.classDescriptions = this.buildClassDescriptions();
            }
        }
        return this.classDescriptions.values().toArray(new ExternalClassDescription[this.classDescriptions.size()]);
    }

    abstract Map buildClassDescriptions();

    ExternalClassDescription getClassDescriptionFor(Class clazz) {
        if (clazz.isArray()) {
            return this.getArrayClassDescriptionFor(clazz);
        }
        ExternalClassDescription externalClassDescription = (ExternalClassDescription)this.classDescriptions.get(clazz.getName());
        if (externalClassDescription == null) {
            throw new IllegalStateException();
        }
        return externalClassDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalClassDescription getArrayClassDescriptionFor(Class clazz) {
        Map map = this.arrayClassDescriptions;
        synchronized (map) {
            ExternalClassDescription externalClassDescription = (ExternalClassDescription)this.arrayClassDescriptions.get(clazz);
            if (externalClassDescription == null) {
                externalClassDescription = new CLExternalClassDescription(clazz.getName(), this);
                this.arrayClassDescriptions.put(clazz, externalClassDescription);
            }
            return externalClassDescription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class loadClass(String string) throws ExternalClassNotFoundException {
        AbstractCLExternalClassRepository abstractCLExternalClassRepository = this;
        synchronized (abstractCLExternalClassRepository) {
            if (this.classLoader == null) {
                this.classLoader = this.buildClassLoader();
            }
        }
        try {
            return Class.forName(string, false, this.classLoader);
        }
        catch (Throwable throwable) {
            throw new ExternalClassNotFoundException(string, throwable);
        }
    }

    abstract ClassLoader buildClassLoader();

    void addClassDescriptionsFromClasspathTo(Classpath classpath, Map map) {
        Classpath.Entry[] entryArray = classpath.getEntries();
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            this.addClassDescriptionsFromClasspathEntryTo(entryArray[i], map);
        }
    }

    private void addClassDescriptionsFromClasspathEntryTo(Classpath.Entry entry, Map map) {
        Iterator iterator = entry.classNamesStream();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (map.containsKey(string)) continue;
            map.put(string, new CLExternalClassDescription(string, entry.canonicalFileName(), this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClassDescriptionsTo(Map map) {
        AbstractCLExternalClassRepository abstractCLExternalClassRepository = this;
        synchronized (abstractCLExternalClassRepository) {
            if (this.classDescriptions == null) {
                this.classDescriptions = this.buildClassDescriptions();
            }
        }
        for (Map.Entry entry : this.classDescriptions.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        String string = this.classDescriptions == null ? "uninitialized" : String.valueOf(this.classDescriptions.size()) + " types";
        return StringTools.buildToStringFor(this, string);
    }
}

