/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.AbstractCLExternalClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.SystemCLExternalClassRepository;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class URLCLExternalClassRepository
extends AbstractCLExternalClassRepository {
    private final Classpath canonicalProjectClasspath;

    URLCLExternalClassRepository(File[] fileArray) {
        Classpath classpath = new Classpath(this.fileNames(fileArray)).compressed();
        Classpath classpath2 = Classpath.completeClasspath();
        this.canonicalProjectClasspath = this.removeDuplicates(classpath2, classpath);
    }

    private String[] fileNames(File[] fileArray) {
        int n = fileArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = fileArray[i].getAbsolutePath();
        }
        return stringArray;
    }

    private Classpath removeDuplicates(Classpath classpath, Classpath classpath2) {
        Set set = CollectionTools.set(classpath.getEntries());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Classpath.Entry entry : classpath2.getEntries()) {
            if (set.contains(entry)) continue;
            arrayList.add(entry.fileName());
        }
        return new Classpath(arrayList);
    }

    public ExternalClassDescription getClassDescription(String string) {
        ExternalClassDescription externalClassDescription = SystemCLExternalClassRepository.instance().getClassDescription(string);
        if (externalClassDescription != null) {
            return externalClassDescription;
        }
        return super.getClassDescription(string);
    }

    Map buildClassDescriptions() {
        HashMap hashMap = new HashMap(20000);
        SystemCLExternalClassRepository.instance().addClassDescriptionsTo(hashMap);
        this.addClassDescriptionsFromClasspathTo(this.canonicalProjectClasspath, hashMap);
        return hashMap;
    }

    ClassLoader buildClassLoader() {
        return new URLClassLoader(this.canonicalProjectClasspath.urls());
    }
}

