/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathStep;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public final class MWXmlField
extends MWModel
implements MWDataField,
MWXmlNode {
    private volatile String xpath = "";
    public static final String XPATH_PROPERTY = "xpath";
    private volatile boolean aggregated = false;
    public static final String AGGREGATED_PROPERTY = "aggregated";
    private volatile boolean typed;
    public static final String TYPED_PROPERTY = "typed";
    private volatile boolean useSingleNode = false;
    public static final String USE_SINGLE_NODE_PROPERTY = "useSingleNode";
    private transient Vector xpathSteps;
    private transient boolean resolved;
    public static final String RESOLVED_PROPERTY = "resolved";
    private transient boolean validPosition = true;
    public static final String VALID_POSITION_PROPERTY = "validPosition";
    private transient boolean validText = true;
    public static final String VALID_TEXT_PROPERTY = "validText";
    public static final String TEXT = "text()";
    private static transient Map jdbcTypeMap;

    private MWXmlField() {
    }

    public MWXmlField(MWXpathContext mWXpathContext) {
        super(mWXpathContext);
    }

    protected void initialize() {
        super.initialize();
        this.xpathSteps = new Vector();
    }

    protected void addTransientAspectNamesTo(Set set) {
        super.addTransientAspectNamesTo(set);
        set.add(RESOLVED_PROPERTY);
        set.add(VALID_POSITION_PROPERTY);
        set.add(VALID_TEXT_PROPERTY);
    }

    public MWXpathContext getXpathContext() {
        return (MWXpathContext)this.getParent();
    }

    public MWSchemaContextComponent schemaContext() {
        return this.getXpathContext().schemaContext(this);
    }

    public MWXpathSpec xpathSpec() {
        return this.getXpathContext().xpathSpec(this);
    }

    protected Iterator xpathSteps() {
        return this.xpathSteps.iterator();
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = this.xpath;
        this.xpath = string;
        if (this.attributeValueHasChanged(string2, string)) {
            this.firePropertyChanged(XPATH_PROPERTY, string2, string);
            this.firePropertyChanged("fieldName", string);
            this.resolve();
            if (!this.xpath.equals("")) {
                this.setAggregated(false);
            }
            if (!this.xpath.endsWith(TEXT)) {
                this.setTyped(false);
            }
        }
    }

    public boolean isTextXpath() {
        return this.getXpath().endsWith(TEXT);
    }

    public boolean isAttributeXpath() {
        return this.getXpath().indexOf(64) != -1;
    }

    public boolean isPositionalXpath() {
        if (this.isResolved()) {
            Iterator iterator = this.xpathSteps();
            while (iterator.hasNext()) {
                if (!((MWXpathStep)iterator.next()).isPositional()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDirect() {
        if (this.isResolved() && !this.isAggregated()) {
            MWXpathStep mWXpathStep = (MWXpathStep)this.xpathSteps.lastElement();
            return mWXpathStep.isAttribute() || mWXpathStep.isText();
        }
        return false;
    }

    public boolean isSingular() {
        boolean bl = true;
        Iterator iterator = this.xpathSteps();
        while (iterator.hasNext()) {
            bl &= ((MWXpathStep)iterator.next()).isSingular();
        }
        return bl;
    }

    public boolean containsXmlField(MWXmlField mWXmlField) {
        return mWXmlField.getXpath().startsWith(this.getXpath());
    }

    public boolean isAggregated() {
        return this.aggregated;
    }

    public void setAggregated(boolean bl) {
        boolean bl2 = this.aggregated;
        this.aggregated = bl;
        this.firePropertyChanged(AGGREGATED_PROPERTY, bl2, bl);
        if (bl) {
            this.setXpath("");
        }
    }

    public boolean isTyped() {
        return this.typed;
    }

    public void setTyped(boolean bl) {
        boolean bl2 = this.typed;
        this.typed = bl;
        this.firePropertyChanged(TYPED_PROPERTY, bl2, bl);
    }

    public boolean usesSingleNode() {
        return this.useSingleNode;
    }

    public void setUseSingleNode(boolean bl) {
        boolean bl2 = this.useSingleNode;
        this.useSingleNode = bl;
        this.firePropertyChanged(USE_SINGLE_NODE_PROPERTY, bl2, bl);
    }

    public boolean isSpecified() {
        return !"".equals(this.xpath) || this.isAggregated();
    }

    public boolean isResolved() {
        return this.resolved;
    }

    private void setResolved(boolean bl) {
        boolean bl2 = this.resolved;
        this.resolved = bl;
        this.firePropertyChanged(RESOLVED_PROPERTY, bl2, bl);
    }

    private void setValidText(boolean bl) {
        boolean bl2 = this.validText;
        this.validText = bl;
        this.firePropertyChanged(VALID_TEXT_PROPERTY, bl2, bl);
    }

    private void setValidPosition(boolean bl) {
        boolean bl2 = this.validPosition;
        this.validPosition = bl;
        this.firePropertyChanged(VALID_POSITION_PROPERTY, bl2, bl);
    }

    public boolean isValid() {
        return this.isResolved() && this.validText && this.validPosition;
    }

    private void resolve() {
        boolean bl;
        MWXpathStep mWXpathStep;
        this.xpathSteps.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(this.xpath, "/");
        while (stringTokenizer.hasMoreTokens()) {
            this.xpathSteps.add(new MWXpathStep(this, stringTokenizer.nextToken()));
        }
        MWSchemaContextComponent mWSchemaContextComponent = this.schemaContext();
        Iterator iterator = this.xpathSteps();
        for (bl = this.isSpecified(); bl && iterator.hasNext(); bl &= mWXpathStep.isResolved()) {
            mWXpathStep = (MWXpathStep)iterator.next();
            mWSchemaContextComponent = mWXpathStep.resolveContext(mWSchemaContextComponent);
        }
        if (!bl) {
            this.xpathSteps.clear();
        }
        this.setResolved(bl);
        this.validateXpath();
    }

    private void resynchXpath() {
        if (this.isResolved()) {
            String string = "";
            Iterator iterator = this.xpathSteps.iterator();
            while (iterator.hasNext()) {
                MWXpathStep mWXpathStep = (MWXpathStep)iterator.next();
                mWXpathStep.updateStepString();
                string = string + mWXpathStep.getStepString();
                if (!iterator.hasNext()) continue;
                string = string + "/";
            }
            this.setXpath(string);
        } else {
            this.resolve();
        }
    }

    private void validateXpath() {
        if (this.isTextXpath()) {
            if (this.isResolved()) {
                this.validateTextXpath();
            } else {
                this.setValidText(false);
            }
        } else {
            this.setValidText(true);
        }
        if (this.isPositionalXpath()) {
            if (this.isResolved()) {
                this.validatePositionalXpath();
            } else {
                this.setValidPosition(false);
            }
        } else {
            this.setValidPosition(true);
        }
    }

    private void validateTextXpath() {
        boolean bl = true;
        Iterator iterator = this.xpathSteps();
        while (iterator.hasNext()) {
            MWXpathStep mWXpathStep = (MWXpathStep)iterator.next();
            if (!mWXpathStep.isText()) continue;
            bl &= mWXpathStep.isValid();
        }
        this.setValidText(bl);
    }

    private void validatePositionalXpath() {
        boolean bl = true;
        Iterator iterator = this.xpathSteps();
        while (iterator.hasNext()) {
            MWXpathStep mWXpathStep = (MWXpathStep)iterator.next();
            if (!mWXpathStep.isPositional()) continue;
            bl &= mWXpathStep.isValid();
        }
        this.setValidPosition(bl);
    }

    public void resolveXpaths() {
        this.resolve();
    }

    public void schemaChanged(SchemaChange schemaChange) {
        if (schemaChange.getChangeType() == 0) {
            this.resolve();
        } else if (schemaChange.getChangeType() == 1) {
            this.resynchXpath();
        }
    }

    public String fieldName() {
        return this.xpath;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkXpath(list);
    }

    private void checkXpath(List list) {
        if (this.isResolved()) {
            if (!this.validText) {
                list.add(this.buildProblem("0812", this.getXpath()));
            }
            if (!this.validPosition) {
                list.add(this.buildProblem("0813", this.getXpath()));
            }
        } else if (!"".equals(this.getXpath())) {
            list.add(this.buildProblem("0811", this.getXpath()));
        }
    }

    public String runtimeFieldName() {
        return this.xpath;
    }

    public DatabaseField runtimeField() {
        if (!this.isSpecified()) {
            return null;
        }
        XMLField xMLField = this.buildRuntimeField();
        xMLField.setXPath(this.runtimeXpath());
        return xMLField;
    }

    public DatabaseField runtimeField(MWXmlField mWXmlField) {
        if (!this.isSpecified()) {
            return null;
        }
        XMLField xMLField = this.buildRuntimeField();
        if (mWXmlField.isSpecified()) {
            xMLField.setXPath(this.runtimeXpath(mWXmlField));
        } else {
            xMLField.setXPath(this.runtimeXpath());
        }
        return xMLField;
    }

    private XMLField buildRuntimeField() {
        XMLUnionField xMLUnionField = null;
        Vector vector = CollectionTools.vector(this.baseBuiltInTypes());
        if (vector.size() > 1) {
            xMLUnionField = new XMLUnionField();
            this.adjustUnionSchemaTypes(xMLUnionField, vector);
        } else {
            xMLUnionField = new XMLField();
            this.adjustNonUnionSchemaTypes((XMLField)xMLUnionField, vector);
        }
        if (this.isTyped()) {
            xMLUnionField.setIsTypedTextField(true);
        }
        if (this.usesSingleNode()) {
            xMLUnionField.setUsesSingleNode(true);
        }
        return xMLUnionField;
    }

    private String runtimeXpath() {
        if (this.isAggregated()) {
            return ".";
        }
        return this.getXpath();
    }

    private String runtimeXpath(MWXmlField mWXmlField) {
        String string = this.runtimeXpath();
        if (mWXmlField.containsXmlField(this)) {
            String string2 = mWXmlField.getXpath();
            if (string.length() > string2.length()) {
                return string.substring(string2.length() + 1);
            }
            return string;
        }
        return string;
    }

    private Iterator baseBuiltInTypes() {
        MWSchemaContextComponent mWSchemaContextComponent = this.xpathComponent();
        if (mWSchemaContextComponent == null) {
            return NullIterator.instance();
        }
        return mWSchemaContextComponent.baseBuiltInTypes();
    }

    private MWSchemaContextComponent xpathComponent() {
        MWSchemaContextComponent mWSchemaContextComponent = null;
        if (TEXT.equals(this.getXpath())) {
            mWSchemaContextComponent = this.schemaContext();
        }
        Iterator iterator = this.xpathSteps();
        while (iterator.hasNext()) {
            MWXpathStep mWXpathStep = (MWXpathStep)iterator.next();
            if (mWXpathStep.xpathComponent() == null) continue;
            mWSchemaContextComponent = mWXpathStep.xpathComponent();
        }
        return mWSchemaContextComponent;
    }

    private void adjustUnionSchemaTypes(XMLUnionField xMLUnionField, Vector vector) {
        if (!this.isDirect()) {
            return;
        }
        for (MWSimpleTypeDefinition mWSimpleTypeDefinition : vector) {
            if (!"http://www.w3.org/2001/XMLSchema".equals(mWSimpleTypeDefinition.getNamespaceUrl())) continue;
            QName qName = this.runtimeSchemaType(mWSimpleTypeDefinition);
            ArrayList arrayList = xMLUnionField.getSchemaTypes();
            if (arrayList != null && arrayList.contains(qName)) continue;
            xMLUnionField.addSchemaType(qName);
        }
    }

    private void adjustNonUnionSchemaTypes(XMLField xMLField, Vector vector) {
        if (!this.isDirect()) {
            return;
        }
        for (MWSimpleTypeDefinition mWSimpleTypeDefinition : vector) {
            QName qName;
            if (!"http://www.w3.org/2001/XMLSchema".equals(mWSimpleTypeDefinition.getNamespaceUrl()) || !this.shouldSetNonUnionRuntimeSchemaType(qName = this.runtimeSchemaType(mWSimpleTypeDefinition))) continue;
            xMLField.setSchemaType(qName);
        }
    }

    private boolean shouldSetNonUnionRuntimeSchemaType(QName qName) {
        return XMLConstants.DATE_QNAME.equals(qName) || XMLConstants.TIME_QNAME.equals(qName) || XMLConstants.DATE_TIME_QNAME.equals(qName) || XMLConstants.BASE_64_BINARY_QNAME.equals(qName) || XMLConstants.HEX_BINARY_QNAME.equals(qName);
    }

    private QName runtimeSchemaType(MWSimpleTypeDefinition mWSimpleTypeDefinition) {
        String string = (String)this.jdbcTypeMap().get(mWSimpleTypeDefinition.getName());
        return new QName("http://www.w3.org/2001/XMLSchema", string);
    }

    private Map jdbcTypeMap() {
        if (jdbcTypeMap == null) {
            MWXmlField.buildJdbcTypeMap();
        }
        return jdbcTypeMap;
    }

    private static void buildJdbcTypeMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("anySimpleType", "anySimpleType");
        hashMap.put("duration", "anySimpleType");
        hashMap.put("dateTime", "dateTime");
        hashMap.put("time", "time");
        hashMap.put("date", "date");
        hashMap.put("gYear", "anySimpleType");
        hashMap.put("gYearMonth", "anySimpleType");
        hashMap.put("gMonth", "anySimpleType");
        hashMap.put("gMonthDay", "anySimpleType");
        hashMap.put("gDay", "anySimpleType");
        hashMap.put("boolean", "boolean");
        hashMap.put("base64Binary", "base64Binary");
        hashMap.put("hexBinary", "hexBinary");
        hashMap.put("anyURI", "anySimpleType");
        hashMap.put("QName", "anySimpleType");
        hashMap.put("NOTATION", "anySimpleType");
        hashMap.put("string", "anySimpleType");
        hashMap.put("normalizedString", "anySimpleType");
        hashMap.put("token", "anySimpleType");
        hashMap.put("language", "anySimpleType");
        hashMap.put("Name", "anySimpleType");
        hashMap.put("NMTOKEN", "anySimpleType");
        hashMap.put("NCName", "anySimpleType");
        hashMap.put("ID", "anySimpleType");
        hashMap.put("IDREF", "IDREF");
        hashMap.put("IDREFS", "IDREFS");
        hashMap.put("ENTITY", "anySimpleType");
        hashMap.put("float", "float");
        hashMap.put("double", "double");
        hashMap.put("decimal", "decimal");
        hashMap.put("integer", "integer");
        hashMap.put("nonPositiveInteger", "integer");
        hashMap.put("negativeInteger", "integer");
        hashMap.put("nonNegativeInteger", "integer");
        hashMap.put("positiveInteger", "integer");
        hashMap.put("unsignedLong", "integer");
        hashMap.put("unsignedInt", "unsignedInt");
        hashMap.put("unsignedShort", "unsignedShort");
        hashMap.put("unsignedByte", "unsignedByte");
        hashMap.put("long", "long");
        hashMap.put("int", "int");
        hashMap.put("short", "short");
        hashMap.put("byte", "byte");
        jdbcTypeMap = hashMap;
    }

    public static int compareSchemaOrder(MWXmlField mWXmlField, MWXmlField mWXmlField2) {
        if (mWXmlField == mWXmlField2 || mWXmlField == null || mWXmlField2 == null || !mWXmlField.isResolved() || !mWXmlField2.isResolved()) {
            return 0;
        }
        if (mWXmlField.schemaContext() != mWXmlField2.schemaContext()) {
            throw new IllegalStateException("XML field \"" + mWXmlField.getXpath() + "\" and XML field \"" + mWXmlField2.getXpath() + "\" are not in the same context.");
        }
        return MWXmlField.compareSchemaOrder(mWXmlField.schemaContext(), mWXmlField.xpathSteps(), mWXmlField2.xpathSteps());
    }

    public static int compareSchemaOrder(MWSchemaContextComponent mWSchemaContextComponent, Iterator iterator, Iterator iterator2) {
        MWXpathStep mWXpathStep;
        if (!iterator.hasNext() || !iterator2.hasNext()) {
            return 0;
        }
        MWXpathStep mWXpathStep2 = (MWXpathStep)iterator.next();
        int n = MWXpathStep.compareSchemaOrder(mWSchemaContextComponent, mWXpathStep2, mWXpathStep = (MWXpathStep)iterator2.next());
        if (n == 0 && mWXpathStep2.xpathComponent() == mWXpathStep.xpathComponent()) {
            return MWXmlField.compareSchemaOrder(mWXpathStep2.xpathComponent(), iterator, iterator2);
        }
        return n;
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append("\"" + this.xpath + "\"");
    }

    public String displayString() {
        return this.xpath;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWXmlField.class);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(XPATH_PROPERTY, TEXT)).setNullValue((Object)"");
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(AGGREGATED_PROPERTY, "@aggregated")).setNullValue((Object)Boolean.FALSE);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping(TYPED_PROPERTY, "@typed")).setNullValue((Object)Boolean.FALSE);
        return xMLDescriptor;
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        this.resolve();
    }
}

