/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.workbench.platformsmodel.JavaTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.w3c.dom.Node;

abstract class AbstractJDBCTypeToJavaTypeDeclarationMapping
extends AbstractNodeModel {
    JDBCType jdbcType;
    JavaTypeDeclaration javaTypeDeclaration;

    AbstractJDBCTypeToJavaTypeDeclarationMapping(JDBCTypeRepository jDBCTypeRepository, Node node) throws CorruptXMLException {
        super(jDBCTypeRepository);
        this.read(node);
    }

    AbstractJDBCTypeToJavaTypeDeclarationMapping(JDBCTypeRepository jDBCTypeRepository, JDBCType jDBCType, String string, int n) {
        super(jDBCTypeRepository);
        if (jDBCType == null) {
            throw new NullPointerException();
        }
        this.jdbcType = jDBCType;
        this.javaTypeDeclaration = new JavaTypeDeclaration(this, string, n);
    }

    private JDBCTypeRepository getJDBCTypeRepository() {
        return (JDBCTypeRepository)this.getParent();
    }

    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    public JavaTypeDeclaration getJavaTypeDeclaration() {
        return this.javaTypeDeclaration;
    }

    private JDBCType jdbcTypeNamed(String string) {
        return this.getJDBCTypeRepository().jdbcTypeNamed(string);
    }

    private void read(Node node) throws CorruptXMLException {
        try {
            this.jdbcType = this.jdbcTypeNamed(XMLTools.childTextContent(node, "jdbc-type", null));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CorruptXMLException(illegalArgumentException);
        }
        this.javaTypeDeclaration = new JavaTypeDeclaration((AbstractNodeModel)this, XMLTools.child(node, "java-type-declaration"));
        ClassTools.setFieldValue(this, "comment", XMLTools.childTextContent(node, "comment", ""));
    }

    abstract void write(Node var1);

    void writeJDBCType(Node node) {
        XMLTools.addSimpleTextNode(node, "jdbc-type", this.jdbcType.getName());
    }

    void writeJavaTypeDeclaration(Node node) {
        this.javaTypeDeclaration.write(node.appendChild(node.getOwnerDocument().createElement("java-type-declaration")));
    }

    void writeComment(Node node) {
        XMLTools.addSimpleTextNode(node, "comment", (String)ClassTools.getFieldValue(this, "comment"), "");
    }

    public abstract void displayStringOn(StringBuffer var1);

    public String displayString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.displayStringOn(stringBuffer);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        this.displayStringOn(stringBuffer);
    }
}

