/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.w3c.dom.Node;

public final class JDBCType
extends AbstractNodeModel {
    private String name;
    public static final String NAME_PROPERTY = "name";
    private int code;
    public static final String CODE_PROPERTY = "code";

    JDBCType(JDBCTypeRepository jDBCTypeRepository, Node node) throws CorruptXMLException {
        super(jDBCTypeRepository);
        this.read(node);
    }

    JDBCType(JDBCTypeRepository jDBCTypeRepository, String string, int n) {
        super(jDBCTypeRepository);
        this.name = string;
        this.code = n;
    }

    private JDBCTypeRepository getJDBCTypeRepository() {
        return (JDBCTypeRepository)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.getJDBCTypeRepository().checkJDBCTypeName(string);
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged(NAME_PROPERTY, string2, string);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n) {
        this.getJDBCTypeRepository().checkJDBCTypeCode(n);
        int n2 = this.code;
        this.code = n;
        this.firePropertyChanged(CODE_PROPERTY, n2, n);
    }

    private void read(Node node) throws CorruptXMLException {
        if (node == null) {
            throw new CorruptXMLException("missing node");
        }
        this.name = XMLTools.childTextContent(node, NAME_PROPERTY, null);
        if (this.name == null || this.name.length() == 0) {
            throw new CorruptXMLException("name is required");
        }
        this.code = XMLTools.childIntContent(node, CODE_PROPERTY, -7777);
    }

    void write(Node node) {
        XMLTools.addSimpleTextNode(node, NAME_PROPERTY, this.name);
        XMLTools.addSimpleTextNode(node, CODE_PROPERTY, this.code, -7777);
    }

    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
    }
}

