/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class AbstractModel
implements Model {
    private ChangeSupport changeSupport;

    protected AbstractModel() {
        this.initialize();
    }

    protected void initialize() {
    }

    private ChangeSupport changeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = this.buildDefaultChangeSupport();
        }
        return this.changeSupport;
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ChangeSupport(this);
    }

    public synchronized void addStateChangeListener(StateChangeListener stateChangeListener) {
        this.changeSupport().addStateChangeListener(stateChangeListener);
    }

    public synchronized void removeStateChangeListener(StateChangeListener stateChangeListener) {
        this.changeSupport().removeStateChangeListener(stateChangeListener);
    }

    protected final void fireStateChanged() {
        this.changeSupport().fireStateChanged();
    }

    protected final void fireStateChanged(StateChangeEvent stateChangeEvent) {
        this.changeSupport().fireStateChanged(stateChangeEvent);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport().addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport().removePropertyChangeListener(string, propertyChangeListener);
    }

    protected final void firePropertyChanged(String string, Object object, Object object2) {
        this.changeSupport().firePropertyChanged(string, object, object2);
    }

    protected final void firePropertyChanged(String string, int n, int n2) {
        this.changeSupport().firePropertyChanged(string, n, n2);
    }

    protected final void firePropertyChanged(String string, boolean bl, boolean bl2) {
        this.changeSupport().firePropertyChanged(string, bl, bl2);
    }

    protected final void firePropertyChanged(String string, Object object) {
        this.changeSupport().firePropertyChanged(string, null, object);
    }

    protected final void firePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        this.changeSupport().firePropertyChanged(propertyChangeEvent);
    }

    public synchronized void addCollectionChangeListener(CollectionChangeListener collectionChangeListener) {
        this.changeSupport().addCollectionChangeListener(collectionChangeListener);
    }

    public synchronized void addCollectionChangeListener(String string, CollectionChangeListener collectionChangeListener) {
        this.changeSupport().addCollectionChangeListener(string, collectionChangeListener);
    }

    public synchronized void removeCollectionChangeListener(CollectionChangeListener collectionChangeListener) {
        this.changeSupport().removeCollectionChangeListener(collectionChangeListener);
    }

    public synchronized void removeCollectionChangeListener(String string, CollectionChangeListener collectionChangeListener) {
        this.changeSupport().removeCollectionChangeListener(string, collectionChangeListener);
    }

    protected final void fireItemAdded(String string, Object object) {
        this.changeSupport().fireItemAdded(string, object);
    }

    protected final void fireItemsAdded(String string, Collection collection) {
        this.changeSupport().fireItemsAdded(string, collection);
    }

    protected final void fireItemsAdded(CollectionChangeEvent collectionChangeEvent) {
        this.changeSupport().fireItemsAdded(collectionChangeEvent);
    }

    protected final void fireItemRemoved(String string, Object object) {
        this.changeSupport().fireItemRemoved(string, object);
    }

    protected final void fireItemsRemoved(String string, Collection collection) {
        this.changeSupport().fireItemsRemoved(string, collection);
    }

    protected final void fireItemsRemoved(CollectionChangeEvent collectionChangeEvent) {
        this.changeSupport().fireItemsRemoved(collectionChangeEvent);
    }

    protected final void fireCollectionChanged(String string) {
        this.changeSupport().fireCollectionChanged(string);
    }

    protected final void fireCollectionChanged(CollectionChangeEvent collectionChangeEvent) {
        this.changeSupport().fireCollectionChanged(collectionChangeEvent);
    }

    protected boolean addItemToCollection(Object object, Collection collection, String string) {
        if (collection.add(object)) {
            this.fireItemAdded(string, object);
            return true;
        }
        return false;
    }

    protected boolean addItemsToCollection(Collection collection, Collection collection2, String string) {
        return this.addItemsToCollection(collection.iterator(), collection2, string);
    }

    protected boolean addItemsToCollection(Iterator iterator, Collection collection, String string) {
        ArrayList arrayList = null;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!collection.add(e)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(e);
        }
        if (arrayList != null) {
            this.fireItemsAdded(string, arrayList);
            return true;
        }
        return false;
    }

    protected boolean removeItemFromCollection(Object object, Collection collection, String string) {
        if (collection.remove(object)) {
            this.fireItemRemoved(string, object);
            return true;
        }
        return false;
    }

    protected boolean removeItemsFromCollection(Collection collection, Collection collection2, String string) {
        return this.removeItemsFromCollection(collection.iterator(), collection2, string);
    }

    protected boolean removeItemsFromCollection(Iterator iterator, Collection collection, String string) {
        Collection collection2 = CollectionTools.collection(iterator);
        collection2.retainAll(collection);
        boolean bl = collection.removeAll(collection2);
        if (!collection2.isEmpty()) {
            this.fireItemsRemoved(string, collection2);
        }
        return bl;
    }

    protected boolean clearCollection(Collection collection, String string) {
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        this.fireCollectionChanged(string);
        return true;
    }

    protected void synchronizeCollection(Collection collection, Collection collection2, String string) {
        HashBag hashBag = new HashBag(collection2);
        hashBag.removeAll(collection);
        this.removeItemsFromCollection(hashBag, collection2, string);
        HashBag hashBag2 = new HashBag(collection);
        hashBag2.removeAll(collection2);
        this.addItemsToCollection(hashBag2, collection2, string);
    }

    protected void synchronizeCollection(Iterator iterator, Collection collection, String string) {
        this.synchronizeCollection(CollectionTools.collection(iterator), collection, string);
    }

    public synchronized void addListChangeListener(ListChangeListener listChangeListener) {
        this.changeSupport().addListChangeListener(listChangeListener);
    }

    public synchronized void addListChangeListener(String string, ListChangeListener listChangeListener) {
        this.changeSupport().addListChangeListener(string, listChangeListener);
    }

    public synchronized void removeListChangeListener(ListChangeListener listChangeListener) {
        this.changeSupport().removeListChangeListener(listChangeListener);
    }

    public synchronized void removeListChangeListener(String string, ListChangeListener listChangeListener) {
        this.changeSupport().removeListChangeListener(string, listChangeListener);
    }

    protected final void fireItemAdded(String string, int n, Object object) {
        this.changeSupport().fireItemAdded(string, n, object);
    }

    protected final void fireItemsAdded(String string, int n, List list) {
        this.changeSupport().fireItemsAdded(string, n, list);
    }

    protected final void fireItemsAdded(ListChangeEvent listChangeEvent) {
        this.changeSupport().fireItemsAdded(listChangeEvent);
    }

    protected final void fireItemRemoved(String string, int n, Object object) {
        this.changeSupport().fireItemRemoved(string, n, object);
    }

    protected final void fireItemsRemoved(String string, int n, List list) {
        this.changeSupport().fireItemsRemoved(string, n, list);
    }

    protected final void fireItemsRemoved(ListChangeEvent listChangeEvent) {
        this.changeSupport().fireItemsRemoved(listChangeEvent);
    }

    protected final void fireItemReplaced(String string, int n, Object object, Object object2) {
        this.changeSupport().fireItemReplaced(string, n, object, object2);
    }

    protected final void fireItemsReplaced(String string, int n, List list, List list2) {
        this.changeSupport().fireItemsReplaced(string, n, list, list2);
    }

    protected final void fireItemsReplaced(ListChangeEvent listChangeEvent) {
        this.changeSupport().fireItemsReplaced(listChangeEvent);
    }

    protected final void fireListChanged(String string) {
        this.changeSupport().fireListChanged(string);
    }

    protected final void fireListChanged(ListChangeEvent listChangeEvent) {
        this.changeSupport().fireListChanged(listChangeEvent);
    }

    protected void addItemToList(int n, Object object, List list, String string) {
        list.add(n, object);
        this.fireItemAdded(string, n, object);
    }

    protected void addItemToList(Object object, List list, String string) {
        this.addItemToList(list.size(), object, list, string);
    }

    protected void addItemsToList(int n, List list, List list2, String string) {
        list2.addAll(n, list);
        this.fireItemsAdded(string, n, list);
    }

    protected void addItemsToList(List list, List list2, String string) {
        this.addItemsToList(list2.size(), list, list2, string);
    }

    protected Object removeItemFromList(int n, List list, String string) {
        Object e = list.remove(n);
        this.fireItemRemoved(string, n, e);
        return e;
    }

    protected Object removeItemFromList(Object object, List list, String string) {
        return this.removeItemFromList(list.indexOf(object), list, string);
    }

    protected List removeItemsFromList(int n, int n2, List list, String string) {
        List list2 = list.subList(n, n + n2);
        ArrayList arrayList = new ArrayList(list2);
        list2.clear();
        this.fireItemsRemoved(string, n, arrayList);
        return arrayList;
    }

    protected Object setItemInList(int n, Object object, List list, String string) {
        Object object2 = list.set(n, object);
        this.fireItemReplaced(string, n, object, object2);
        return object2;
    }

    protected Object replaceItemInList(Object object, Object object2, List list, String string) {
        return this.setItemInList(list.indexOf(object), object2, list, string);
    }

    protected List setItemsInList(int n, List list, List list2, String string) {
        List list3 = list2.subList(n, n + list.size());
        ArrayList arrayList = new ArrayList(list3);
        for (int i = 0; i < list.size(); ++i) {
            list3.set(i, list.get(i));
        }
        this.fireItemsReplaced(string, n, list, arrayList);
        return arrayList;
    }

    protected boolean clearList(List list, String string) {
        if (list.isEmpty()) {
            return false;
        }
        list.clear();
        this.fireListChanged(string);
        return true;
    }

    public synchronized void addTreeChangeListener(TreeChangeListener treeChangeListener) {
        this.changeSupport().addTreeChangeListener(treeChangeListener);
    }

    public synchronized void addTreeChangeListener(String string, TreeChangeListener treeChangeListener) {
        this.changeSupport().addTreeChangeListener(string, treeChangeListener);
    }

    public synchronized void removeTreeChangeListener(TreeChangeListener treeChangeListener) {
        this.changeSupport().removeTreeChangeListener(treeChangeListener);
    }

    public synchronized void removeTreeChangeListener(String string, TreeChangeListener treeChangeListener) {
        this.changeSupport().removeTreeChangeListener(string, treeChangeListener);
    }

    protected final void fireNodeAdded(String string, Object[] objectArray) {
        this.changeSupport().fireNodeAdded(string, objectArray);
    }

    protected final void fireNodeAdded(TreeChangeEvent treeChangeEvent) {
        this.changeSupport().fireNodeAdded(treeChangeEvent);
    }

    protected final void fireNodeRemoved(String string, Object[] objectArray) {
        this.changeSupport().fireNodeRemoved(string, objectArray);
    }

    protected final void fireNodeRemoved(TreeChangeEvent treeChangeEvent) {
        this.changeSupport().fireNodeRemoved(treeChangeEvent);
    }

    protected final void fireTreeStructureChanged(String string) {
        this.changeSupport().fireTreeChanged(string);
    }

    protected final void fireTreeStructureChanged(String string, Object[] objectArray) {
        this.changeSupport().fireTreeChanged(string, objectArray);
    }

    protected final void fireTreeStructureChanged(TreeChangeEvent treeChangeEvent) {
        this.changeSupport().fireTreeChanged(treeChangeEvent);
    }

    public boolean hasAnyStateChangeListeners() {
        return this.changeSupport().hasAnyStateChangeListeners();
    }

    public boolean hasNoStateChangeListeners() {
        return !this.hasAnyStateChangeListeners();
    }

    public boolean hasAnyPropertyChangeListeners(String string) {
        return this.changeSupport().hasAnyPropertyChangeListeners(string);
    }

    public boolean hasNoPropertyChangeListeners(String string) {
        return !this.hasAnyPropertyChangeListeners(string);
    }

    public boolean hasAnyCollectionChangeListeners(String string) {
        return this.changeSupport().hasAnyCollectionChangeListeners(string);
    }

    public boolean hasNoCollectionChangeListeners(String string) {
        return !this.hasAnyCollectionChangeListeners(string);
    }

    public boolean hasAnyListChangeListeners(String string) {
        return this.changeSupport().hasAnyListChangeListeners(string);
    }

    public boolean hasNoListChangeListeners(String string) {
        return !this.hasAnyListChangeListeners(string);
    }

    public boolean hasAnyTreeChangeListeners(String string) {
        return this.changeSupport().hasAnyTreeChangeListeners(string);
    }

    public boolean hasNoTreeChangeListeners(String string) {
        return !this.hasAnyTreeChangeListeners(string);
    }

    protected final boolean valuesAreEqual(Object object, Object object2) {
        return this.changeSupport().valuesAreEqual(object, object2);
    }

    protected final boolean attributeValueHasNotChanged(Object object, Object object2) {
        return this.valuesAreEqual(object, object2);
    }

    protected final boolean valuesAreDifferent(Object object, Object object2) {
        return this.changeSupport().valuesAreDifferent(object, object2);
    }

    protected final boolean attributeValueHasChanged(Object object, Object object2) {
        return this.valuesAreDifferent(object, object2);
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractModel abstractModel = (AbstractModel)super.clone();
        abstractModel.postClone();
        return abstractModel;
    }

    protected void postClone() {
        this.changeSupport = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTools.buildSimpleToStringOn(this, stringBuffer);
        stringBuffer.append(" (");
        this.toString(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
    }
}

