/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.Bag;

public class HashBag
extends AbstractCollection
implements Bag,
Cloneable,
Serializable {
    transient Entry[] table;
    transient int count = 0;
    transient int uniqueCount = 0;
    private int threshold;
    private float loadFactor;
    transient int modCount = 0;
    private static Iterator emptyIterator = new EmptyIterator();
    private static final long serialVersionUID = 1L;

    public HashBag() {
        this(11, 0.75f);
    }

    public HashBag(int n) {
        this(n, 0.75f);
    }

    public HashBag(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public HashBag(Collection collection) {
        this(Math.max(2 * collection.size(), 11));
        this.addAll(collection);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        Entry[] entryArray = this.table;
        if (object == null) {
            Entry entry = entryArray[0];
            while (entry != null) {
                if (entry.object == null) {
                    return true;
                }
                entry = entry.next;
            }
        } else {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public int count(Object object) {
        Entry[] entryArray = this.table;
        if (object == null) {
            Entry entry = entryArray[0];
            while (entry != null) {
                if (entry.object == null) {
                    return entry.count;
                }
                entry = entry.next;
            }
        } else {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.object)) {
                    return entry.count;
                }
                entry = entry.next;
            }
        }
        return 0;
    }

    private void rehash() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public boolean add(Object object) {
        Entry entry;
        ++this.modCount;
        Entry[] entryArray = this.table;
        int n = 0;
        int n2 = 0;
        if (object == null) {
            entry = entryArray[0];
            while (entry != null) {
                if (entry.object == null) {
                    ++entry.count;
                    ++this.count;
                    return true;
                }
                entry = entry.next;
            }
        } else {
            n = object.hashCode();
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.object)) {
                    ++entry.count;
                    ++this.count;
                    return true;
                }
                entry = entry.next;
            }
        }
        if (this.uniqueCount >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, entryArray[n2]);
        ++this.count;
        ++this.uniqueCount;
        return true;
    }

    public boolean remove(Object object) {
        Entry[] entryArray = this.table;
        if (object == null) {
            Entry entry = entryArray[0];
            Entry entry2 = null;
            while (entry != null) {
                if (entry.object == null) {
                    ++this.modCount;
                    --entry.count;
                    if (entry.count == 0) {
                        if (entry2 == null) {
                            entryArray[0] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        --this.uniqueCount;
                    }
                    --this.count;
                    return true;
                }
                entry2 = entry;
                entry = entry.next;
            }
        } else {
            int n = object.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            Entry entry3 = null;
            while (entry != null) {
                if (entry.hash == n && object.equals(entry.object)) {
                    ++this.modCount;
                    --entry.count;
                    if (entry.count == 0) {
                        if (entry3 == null) {
                            entryArray[n2] = entry.next;
                        } else {
                            entry3.next = entry.next;
                        }
                        --this.uniqueCount;
                    }
                    --this.count;
                    return true;
                }
                entry3 = entry;
                entry = entry.next;
            }
        }
        return false;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
        this.uniqueCount = 0;
    }

    public Object clone() {
        try {
            HashBag hashBag = (HashBag)super.clone();
            hashBag.table = new Entry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                hashBag.table[n] = this.table[n] == null ? null : (Entry)this.table[n].clone();
            }
            hashBag.modCount = 0;
            return hashBag;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Iterator iterator() {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new HashIterator();
    }

    public Iterator uniqueIterator() {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new UniqueIterator();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Bag)) {
            return false;
        }
        Bag bag = (Bag)object;
        if (bag.size() != this.size()) {
            return false;
        }
        Bag bag2 = (Bag)this.clone();
        for (Object e : bag) {
            if (bag2.remove(e)) continue;
            return false;
        }
        return bag2.isEmpty();
    }

    public int hashCode() {
        int n = 0;
        for (Object e : this) {
            if (e == null) continue;
            n += e.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.uniqueCount);
        Entry[] entryArray = this.table;
        for (int i = entryArray.length - 1; i >= 0; --i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                objectOutputStream.writeObject(entry.object);
                objectOutputStream.writeInt(entry.count);
                entry = entry.next;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.table = new Entry[objectInputStream.readInt()];
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            int n2 = objectInputStream.readInt();
            for (int j = 0; j < n2; ++j) {
                this.add(object);
            }
        }
    }

    private class UniqueIterator
    implements Iterator {
        Entry[] localTable;
        int index;
        Entry nextEntry;
        Entry lastReturnedEntry;
        private int expectedModCount;

        UniqueIterator() {
            this.localTable = HashBag.this.table;
            this.index = this.localTable.length;
            this.nextEntry = null;
            this.lastReturnedEntry = null;
            this.expectedModCount = HashBag.this.modCount;
        }

        public boolean hasNext() {
            Entry entry = this.nextEntry;
            int n = this.index;
            Entry[] entryArray = this.localTable;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.nextEntry = entry;
            this.index = n;
            return entry != null;
        }

        public Object next() {
            if (HashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.nextEntry;
            int n = this.index;
            Entry[] entryArray = this.localTable;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.nextEntry = entry;
            this.index = n;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = this.lastReturnedEntry = this.nextEntry;
            this.nextEntry = entry2.next;
            return entry2.object;
        }

        public void remove() {
            if (this.lastReturnedEntry == null) {
                throw new IllegalStateException();
            }
            if (HashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] entryArray = this.localTable;
            int n = (this.lastReturnedEntry.hash & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturnedEntry) {
                    ++HashBag.this.modCount;
                    ++this.expectedModCount;
                    if (entry2 == null) {
                        entryArray[n] = entry.next;
                    } else {
                        entry2.next = entry.next;
                    }
                    --HashBag.this.uniqueCount;
                    HashBag.this.count -= this.lastReturnedEntry.count;
                    this.lastReturnedEntry = null;
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] localTable;
        int index;
        Entry nextEntry;
        int nextEntryCount;
        Entry lastReturnedEntry;
        private int expectedModCount;

        HashIterator() {
            this.localTable = HashBag.this.table;
            this.index = this.localTable.length;
            this.nextEntry = null;
            this.nextEntryCount = 0;
            this.lastReturnedEntry = null;
            this.expectedModCount = HashBag.this.modCount;
        }

        public boolean hasNext() {
            Entry entry = this.nextEntry;
            int n = this.index;
            Entry[] entryArray = this.localTable;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.nextEntry = entry;
            this.index = n;
            return entry != null;
        }

        public Object next() {
            if (HashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.nextEntry;
            int n = this.index;
            Entry[] entryArray = this.localTable;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.nextEntry = entry;
            this.index = n;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = this.lastReturnedEntry = this.nextEntry;
            ++this.nextEntryCount;
            if (this.nextEntryCount == entry2.count) {
                this.nextEntry = entry2.next;
                this.nextEntryCount = 0;
            }
            return entry2.object;
        }

        public void remove() {
            if (this.lastReturnedEntry == null) {
                throw new IllegalStateException();
            }
            if (HashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] entryArray = this.localTable;
            int n = (this.lastReturnedEntry.hash & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturnedEntry) {
                    ++HashBag.this.modCount;
                    ++this.expectedModCount;
                    --entry.count;
                    if (entry.count == 0) {
                        if (entry2 == null) {
                            entryArray[n] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        --HashBag.this.uniqueCount;
                    } else {
                        --this.nextEntryCount;
                    }
                    --HashBag.this.count;
                    this.lastReturnedEntry = null;
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class Entry {
        int hash;
        Object object;
        int count;
        Entry next;

        Entry(int n, Object object, Entry entry) {
            this(n, object, 1, entry);
        }

        private Entry(int n, Object object, int n2, Entry entry) {
            this.hash = n;
            this.object = object;
            this.count = n2;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.object, this.count, this.next == null ? null : (Entry)this.next.clone());
        }

        public String toString() {
            return this.object + "=>" + this.count;
        }
    }
}

