/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;

public final class NameTools {
    public static final String[] JAVA_RESERVED_WORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    public static final Set JAVA_RESERVED_WORDS_SET = CollectionTools.set(JAVA_RESERVED_WORDS);

    public static String uniqueJavaNameFor(String string, Iterator iterator) {
        Set set = CollectionTools.set(iterator);
        NameTools.addJavaReservedWordsTo(set);
        return NameTools.uniqueNameFor(string, set, string);
    }

    public static String uniqueJavaNameFor(String string, Collection collection) {
        HashSet hashSet = new HashSet(collection);
        NameTools.addJavaReservedWordsTo(hashSet);
        return NameTools.uniqueNameFor(string, hashSet, string);
    }

    public static String uniqueNameFor(String string, Iterator iterator) {
        return NameTools.uniqueNameFor(string, CollectionTools.set(iterator));
    }

    public static String uniqueNameFor(String string, Collection collection) {
        return NameTools.uniqueNameFor(string, collection, string);
    }

    public static String uniqueNameForIgnoreCase(String string, Iterator iterator) {
        return NameTools.uniqueNameForIgnoreCase(string, CollectionTools.set(iterator));
    }

    public static String uniqueNameForIgnoreCase(String string, Collection collection) {
        return NameTools.uniqueNameFor(string, NameTools.convertToLowerCase(collection), string.toLowerCase());
    }

    private static String uniqueNameFor(String string, Collection collection, String string2) {
        if (!collection.contains(string2)) {
            return string;
        }
        String string3 = string2;
        int n = 2;
        while (collection.contains(string3 + n)) {
            ++n;
        }
        return string.concat(String.valueOf(n));
    }

    private static Collection convertToLowerCase(Collection collection) {
        HashBag hashBag = new HashBag(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashBag.add(((String)iterator.next()).toLowerCase());
        }
        return hashBag;
    }

    public static String buildQualifiedDatabaseObjectName(String string, String string2, String string3) {
        if (string3 == null) {
            throw new IllegalArgumentException();
        }
        if (string == null && string2 == null) {
            return string3;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('.');
        }
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append('.');
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public static void addJavaReservedWordsTo(Collection collection) {
        CollectionTools.addAll(collection, (Object[])JAVA_RESERVED_WORDS);
    }

    public static Iterator javaReservedWords() {
        return new ArrayIterator(JAVA_RESERVED_WORDS);
    }

    public static boolean javaReservedWordsContains(String string) {
        return JAVA_RESERVED_WORDS_SET.contains(string);
    }

    private NameTools() {
        throw new UnsupportedOperationException();
    }
}

