/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.Serializable;
import org.eclipse.persistence.tools.workbench.utility.Command;

public class SynchronizedBoolean
implements Cloneable,
Serializable {
    private boolean value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedBoolean(boolean bl, Object object) {
        this.value = bl;
        this.mutex = object;
    }

    public SynchronizedBoolean(boolean bl) {
        this.value = bl;
        this.mutex = this;
    }

    public SynchronizedBoolean(Object object) {
        this(false, object);
    }

    public SynchronizedBoolean() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getValue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTrue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFalse() {
        Object object = this.mutex;
        synchronized (object) {
            return !this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(boolean bl) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.value != bl) {
                this.value = bl;
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrue() {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFalse() {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue(false);
        }
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIs(boolean bl) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.value != bl) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilTrue() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFalse() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetTrue() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilFalse();
            this.setValue(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetFalse() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilTrue();
            this.setValue(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIs(boolean bl, long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            if (l == 0L) {
                this.waitUntilValueIs(bl);
                return true;
            }
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            while (this.value != bl && l3 > 0L) {
                this.mutex.wait(l3);
                l3 = l2 - System.currentTimeMillis();
            }
            return this.value == bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilTrue(long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs(true, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilFalse(long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs(false, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetTrue(long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = this.waitUntilFalse(l);
            if (bl) {
                this.setValue(true);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetFalse(long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = this.waitUntilTrue(l);
            if (bl) {
                this.setValue(false);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                return super.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SynchronizedBoolean) {
            return this.getValue() == ((SynchronizedBoolean)object).getValue();
        }
        return false;
    }

    public int hashCode() {
        return this.getValue() ? 1 : 0;
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }
}

