/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.Serializable;
import java.util.EmptyStackException;
import org.eclipse.persistence.tools.workbench.utility.Command;
import org.eclipse.persistence.tools.workbench.utility.SimpleStack;
import org.eclipse.persistence.tools.workbench.utility.Stack;

public class SynchronizedStack
implements Stack,
Serializable {
    private Stack stack;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedStack(Stack stack, Object object) {
        this.stack = stack;
        this.mutex = object;
    }

    public SynchronizedStack(Stack stack) {
        this.stack = stack;
        this.mutex = this;
    }

    public SynchronizedStack(Object object) {
        this(new SimpleStack(), object);
    }

    public SynchronizedStack() {
        this(new SimpleStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.stack.push(object);
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pop() {
        Object object = this.mutex;
        synchronized (object) {
            Object object2 = this.stack.pop();
            this.mutex.notifyAll();
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmptyIs(boolean bl) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.isEmpty() != bl) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmpty() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNotEmpty() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToPush(Object object) throws InterruptedException {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.waitUntilEmpty();
            this.push(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitToPop() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilNotEmpty();
            return this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmptyIs(boolean bl, long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            if (l == 0L) {
                this.waitUntilEmptyIs(bl);
                return true;
            }
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            while (this.isEmpty() != bl && l3 > 0L) {
                this.mutex.wait(l3);
                l3 = l2 - System.currentTimeMillis();
            }
            return this.isEmpty() == bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmpty(long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilEmptyIs(true, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNotEmpty(long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilEmptyIs(false, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToPush(Object object, long l) throws InterruptedException {
        Object object2 = this.mutex;
        synchronized (object2) {
            boolean bl = this.waitUntilEmpty(l);
            if (bl) {
                this.push(object);
            }
            return bl;
        }
    }

    public Object waitToPop(long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = this.waitUntilNotEmpty(l);
            if (bl) {
                return this.pop();
            }
            throw new EmptyStackException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return this.stack.toString();
        }
    }
}

