/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.Serializable;

public class TriStateBoolean
implements Cloneable,
Serializable {
    private final Boolean value;
    private static final long serialVersionUID = 1L;
    public static final TriStateBoolean FALSE = new TriStateBoolean(Boolean.FALSE);
    public static final TriStateBoolean TRUE = new TriStateBoolean(Boolean.TRUE);
    public static final TriStateBoolean UNDEFINED = new TriStateBoolean((Boolean)null);

    public static TriStateBoolean valueOf(Boolean bl) {
        return bl == null ? UNDEFINED : (bl != false ? TRUE : FALSE);
    }

    public static TriStateBoolean valueOf(String string) {
        return TriStateBoolean.valueOf(TriStateBoolean.toBoolean(string));
    }

    public static TriStateBoolean valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static TriStateBoolean getTriStateBoolean(String string) {
        try {
            return TriStateBoolean.valueOf(System.getProperty(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return UNDEFINED;
    }

    private static Boolean toBoolean(String string) {
        return string == null || string.equalsIgnoreCase("undefined") ? null : Boolean.valueOf(string);
    }

    public TriStateBoolean(Boolean bl) {
        this.value = bl == null ? null : (bl != false ? Boolean.TRUE : Boolean.FALSE);
    }

    public TriStateBoolean(boolean bl) {
        this.value = bl;
    }

    public TriStateBoolean(String string) {
        this(TriStateBoolean.toBoolean(string));
    }

    public Boolean getValue() {
        return this.value;
    }

    public boolean booleanValue() {
        if (this.value == null) {
            throw new IllegalStateException();
        }
        return this.value;
    }

    public boolean valueIs(boolean bl) {
        return this.value == null ? false : this.value == bl;
    }

    public boolean isFalse() {
        return this.valueIs(false);
    }

    public boolean isTrue() {
        return this.valueIs(true);
    }

    public boolean isUndefined() {
        return this.value == null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof TriStateBoolean && this.value == ((TriStateBoolean)object).value;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.value == null ? "undefined" : this.value.toString();
    }
}

