/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLTools {
    private static DocumentBuilderFactory documentBuilderFactory;
    private static DocumentBuilder documentBuilder;
    private static TransformerFactory transformerFactory;
    private static Transformer transformer;

    private static synchronized DocumentBuilderFactory documentBuilderFactory() {
        if (documentBuilderFactory == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return documentBuilderFactory;
    }

    private static synchronized DocumentBuilder documentBuilder() {
        if (documentBuilder == null) {
            try {
                documentBuilder = XMLTools.documentBuilderFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException);
            }
        }
        return documentBuilder;
    }

    public static synchronized Document parse(InputSource inputSource) {
        try {
            return XMLTools.documentBuilder().parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(Reader reader) {
        Document document = null;
        try {
            document = XMLTools.parse(new InputSource(reader));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return document;
    }

    public static Document parse(InputStream inputStream) {
        try {
            return XMLTools.parse(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static Document parse(File file) {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 8192);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        Document document = XMLTools.parse(bufferedInputStream);
        try {
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return document;
    }

    public static Node child(Node node, String string) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static Node[] children(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>(n);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            arrayList.add(node2);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public static Node[] children(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>(n);
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public static String textContent(Node node) {
        Node node2;
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return "";
        }
        if (nodeList.getLength() == 1 && (node2 = nodeList.item(0)).getNodeType() == 3) {
            return node.getFirstChild().getNodeValue();
        }
        throw new IllegalArgumentException(node.getNodeName());
    }

    public static String childTextContent(Node node, String string) {
        return XMLTools.textContent(XMLTools.child(node, string));
    }

    public static String childTextContent(Node node, String string, String string2) {
        Node node2 = XMLTools.child(node, string);
        if (node2 == null) {
            return string2;
        }
        return XMLTools.textContent(node2);
    }

    public static int childIntContent(Node node, String string) {
        return XMLTools.convertToInt(XMLTools.textContent(XMLTools.child(node, string)));
    }

    public static int childIntContent(Node node, String string, int n) {
        Node node2 = XMLTools.child(node, string);
        if (node2 == null) {
            return n;
        }
        return XMLTools.convertToInt(XMLTools.textContent(node2));
    }

    private static int convertToInt(String string) {
        return Integer.parseInt(string);
    }

    public static boolean childBooleanContent(Node node, String string) {
        return XMLTools.convertToBoolean(XMLTools.textContent(XMLTools.child(node, string)));
    }

    public static boolean childBooleanContent(Node node, String string, boolean bl) {
        Node node2 = XMLTools.child(node, string);
        if (node2 == null) {
            return bl;
        }
        return XMLTools.convertToBoolean(XMLTools.textContent(node2));
    }

    private static boolean convertToBoolean(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("t") || string2.equals("true") || string2.equals("1")) {
            return true;
        }
        if (string2.equals("f") || string2.equals("false") || string2.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException(string);
    }

    public static Document newDocument() {
        return XMLTools.documentBuilder().newDocument();
    }

    public static void addSimpleTextNode(Node node, String string, String string2) {
        Element element = node.getOwnerDocument().createElement(string);
        Text text = node.getOwnerDocument().createTextNode(string2);
        element.appendChild(text);
        node.appendChild(element);
    }

    public static void addSimpleTextNode(Node node, String string, String string2, String string3) {
        if (!string2.equals(string3)) {
            XMLTools.addSimpleTextNode(node, string, string2);
        }
    }

    public static void addSimpleTextNode(Node node, String string, int n) {
        XMLTools.addSimpleTextNode(node, string, String.valueOf(n));
    }

    public static void addSimpleTextNode(Node node, String string, int n, int n2) {
        if (n != n2) {
            XMLTools.addSimpleTextNode(node, string, n);
        }
    }

    public static void addSimpleTextNode(Node node, String string, boolean bl) {
        XMLTools.addSimpleTextNode(node, string, String.valueOf(bl));
    }

    public static void addSimpleTextNode(Node node, String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            XMLTools.addSimpleTextNode(node, string, bl);
        }
    }

    public static void addSimpleTextNodes(Node node, String string, String string2, String[] stringArray) {
        Element element = node.getOwnerDocument().createElement(string);
        node.appendChild(element);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            XMLTools.addSimpleTextNode((Node)element, string2, stringArray[i]);
        }
    }

    private static synchronized TransformerFactory transformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    private static synchronized Transformer transformer() {
        if (transformer == null) {
            try {
                transformer = XMLTools.transformerFactory().newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new RuntimeException(transformerConfigurationException);
            }
            try {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return transformer;
    }

    public static synchronized void print(Source source, Result result) {
        try {
            XMLTools.transformer().transform(source, result);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
    }

    public static void print(Document document, OutputStream outputStream) {
        XMLTools.print(new DOMSource(document), new StreamResult(outputStream));
    }

    public static void print(Document document, File file) {
        BufferedOutputStream bufferedOutputStream;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 8192);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        XMLTools.print(document, bufferedOutputStream);
        try {
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private XMLTools() {
        throw new UnsupportedOperationException();
    }
}

