/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringReader;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.MemberRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Method;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;

public abstract class AbstractMethodRefConstant
extends MemberRefConstant {
    private FieldType returnDescriptor;
    private FieldType[] parameterDescriptors;

    AbstractMethodRefConstant(ConstantPool constantPool, byte by, ClassFileDataInputStream classFileDataInputStream) throws IOException {
        super(constantPool, by, classFileDataInputStream);
    }

    public boolean isConstructor() {
        return this.name().equals("<init>");
    }

    public boolean isStaticInitializationMethod() {
        return this.name().equals("<clinit>");
    }

    public void accept(Visitor visitor) {
        this.getReturnDescriptor().accept(visitor);
        FieldType[] fieldTypeArray = this.getParameterDescriptors();
        int n = fieldTypeArray.length;
        for (int i = 0; i < n; ++i) {
            fieldTypeArray[i].accept(visitor);
        }
    }

    public FieldType getReturnDescriptor() {
        if (this.returnDescriptor == null) {
            this.buildDescriptors();
        }
        return this.returnDescriptor;
    }

    public FieldType[] getParameterDescriptors() {
        if (this.parameterDescriptors == null) {
            this.buildDescriptors();
        }
        return this.parameterDescriptors;
    }

    public FieldType getParameterDescriptor(int n) {
        if (this.parameterDescriptors == null) {
            this.buildDescriptors();
        }
        return this.parameterDescriptors[n];
    }

    private void buildDescriptors() {
        StringReader stringReader = new StringReader(this.descriptor());
        try {
            this.parameterDescriptors = Method.buildParameterDescriptors(stringReader);
            this.returnDescriptor = FieldType.createFieldType(stringReader);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

