/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.ExceptionHandler;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class CodeAttribute
extends Attribute {
    private short maxStack;
    private short maxLocals;
    private int codeLength;
    private byte[] code;
    private short exceptionHandlerCount;
    private ExceptionHandler[] exceptionHandlers;
    private AttributePool attributePool;

    CodeAttribute(ClassFileDataInputStream classFileDataInputStream, short s, AttributePool attributePool) throws IOException {
        super(classFileDataInputStream, s, attributePool);
    }

    void initializeInfo(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.maxStack = classFileDataInputStream.readU2();
        this.maxLocals = classFileDataInputStream.readU2();
        int n = this.codeLength = classFileDataInputStream.readU4();
        this.code = new byte[n];
        classFileDataInputStream.read(this.code);
        short s = this.exceptionHandlerCount = classFileDataInputStream.readU2();
        ExceptionHandler[] exceptionHandlerArray = this.exceptionHandlers = new ExceptionHandler[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            exceptionHandlerArray[s2] = new ExceptionHandler(classFileDataInputStream, this.constantPool());
        }
        this.attributePool = new AttributePool(classFileDataInputStream, this.classFile());
    }

    void displayInfoStringOn(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.print("max stack: ");
        indentingPrintWriter.println(this.maxStack);
        indentingPrintWriter.print("max locals: ");
        indentingPrintWriter.println(this.maxLocals);
        indentingPrintWriter.print("code: ");
        this.writeHexStringOn(this.code, indentingPrintWriter);
        indentingPrintWriter.println();
        short s = this.exceptionHandlerCount;
        indentingPrintWriter.print("Exception Handlers (count: ");
        indentingPrintWriter.print(s);
        indentingPrintWriter.println(")");
        indentingPrintWriter.indent();
        ExceptionHandler[] exceptionHandlerArray = this.exceptionHandlers;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            indentingPrintWriter.print(s2);
            indentingPrintWriter.print(": ");
            exceptionHandlerArray[s2].displayStringOn(indentingPrintWriter);
        }
        indentingPrintWriter.undent();
        this.attributePool.displayStringOn(indentingPrintWriter);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short s = this.exceptionHandlerCount;
        ExceptionHandler[] exceptionHandlerArray = this.exceptionHandlers;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            exceptionHandlerArray[s2].accept(visitor);
        }
        this.attributePool.accept(visitor);
    }

    public short getMaxStack() {
        return this.maxStack;
    }

    public short getMaxLocals() {
        return this.maxLocals;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public byte[] getCode() {
        return this.code;
    }

    public short getExceptionHandlerCount() {
        return this.exceptionHandlerCount;
    }

    public ExceptionHandler getExceptionHandler(short s) {
        return this.exceptionHandlers[s];
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public AttributePool getAttributePool() {
        return this.attributePool;
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append("code length: ");
        stringBuffer.append(this.codeLength);
    }
}

