/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.DoubleConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.FieldRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.FloatConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.IntegerConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.InterfaceMethodRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.LongConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.MethodRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.NameAndTypeConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.NullConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.StringConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.UTF8Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public abstract class Constant {
    private ConstantPool pool;
    private byte tag;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_Utf8 = 1;

    static Constant nullConstant(ConstantPool constantPool, ClassFileDataInputStream classFileDataInputStream) throws IOException {
        return new NullConstant(constantPool, 0, classFileDataInputStream);
    }

    static Constant buildConstant(ConstantPool constantPool, ClassFileDataInputStream classFileDataInputStream) throws IOException {
        return Constant.buildConstant(constantPool, classFileDataInputStream.readU1(), classFileDataInputStream);
    }

    private static Constant buildConstant(ConstantPool constantPool, byte by, ClassFileDataInputStream classFileDataInputStream) throws IOException {
        switch (by) {
            case 1: {
                return new UTF8Constant(constantPool, by, classFileDataInputStream);
            }
            case 3: {
                return new IntegerConstant(constantPool, by, classFileDataInputStream);
            }
            case 4: {
                return new FloatConstant(constantPool, by, classFileDataInputStream);
            }
            case 5: {
                return new LongConstant(constantPool, by, classFileDataInputStream);
            }
            case 6: {
                return new DoubleConstant(constantPool, by, classFileDataInputStream);
            }
            case 7: {
                return new ClassConstant(constantPool, by, classFileDataInputStream);
            }
            case 8: {
                return new StringConstant(constantPool, by, classFileDataInputStream);
            }
            case 9: {
                return new FieldRefConstant(constantPool, by, classFileDataInputStream);
            }
            case 10: {
                return new MethodRefConstant(constantPool, by, classFileDataInputStream);
            }
            case 11: {
                return new InterfaceMethodRefConstant(constantPool, by, classFileDataInputStream);
            }
            case 12: {
                return new NameAndTypeConstant(constantPool, by, classFileDataInputStream);
            }
        }
        throw new IOException("Invalid constant tag: " + by);
    }

    Constant(ConstantPool constantPool, byte by, ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.pool = constantPool;
        this.tag = by;
        this.initialize(classFileDataInputStream);
    }

    abstract void initialize(ClassFileDataInputStream var1) throws IOException;

    public String displayString() {
        StringWriter stringWriter = new StringWriter(100);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.print("tag: ");
        indentingPrintWriter.print(this.tag);
        indentingPrintWriter.print(" (");
        indentingPrintWriter.print(this.description());
        indentingPrintWriter.print(")");
    }

    public abstract String description();

    public void printFieldInitializationClauseOn(PrintWriter printWriter) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ConstantPool getPool() {
        return this.pool;
    }

    public byte getTag() {
        return this.tag;
    }

    public String utf8String(short s) {
        return this.pool.getUTF8String(s);
    }

    boolean consumesTwoPoolEntries() {
        return false;
    }

    public abstract Object value();

    public abstract void accept(Visitor var1);

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassTools.shortClassNameForObject(this));
        stringBuffer.append('(');
        this.toString(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.value());
    }
}

