/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.DoubleConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.FieldRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.FloatConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.IntegerConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.InterfaceMethodRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.LongConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.MethodRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.NameAndTypeConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.StringConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.UTF8Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ConstantPool {
    private short count;
    private Constant[] constants;

    ConstantPool(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.initialize(classFileDataInputStream);
    }

    private void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        short s = this.count = classFileDataInputStream.readU2();
        Constant[] constantArray = this.constants = new Constant[s];
        constantArray[0] = Constant.nullConstant(this, classFileDataInputStream);
        for (short s2 = 1; s2 < s; s2 = (short)(s2 + 1)) {
            Constant constant;
            constantArray[s2] = constant = Constant.buildConstant(this, classFileDataInputStream);
            if (!constant.consumesTwoPoolEntries()) continue;
            s2 = (short)(s2 + 1);
            constantArray[s2] = Constant.nullConstant(this, classFileDataInputStream);
        }
    }

    public String displayString() {
        StringWriter stringWriter = new StringWriter(1000);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        short s = this.count;
        Constant[] constantArray = this.constants;
        indentingPrintWriter.print("Constant Pool (count: ");
        indentingPrintWriter.print(s);
        indentingPrintWriter.println(')');
        indentingPrintWriter.indent();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            indentingPrintWriter.print(s2);
            indentingPrintWriter.print(": ");
            constantArray[s2].displayStringOn(indentingPrintWriter);
        }
        indentingPrintWriter.undent();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short s = this.count;
        Constant[] constantArray = this.constants;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            constantArray[s2].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public Constant get(short s) {
        return this.constants[s];
    }

    public ClassConstant getClassConstant(short s) {
        return (ClassConstant)this.constants[s];
    }

    public DoubleConstant getDoubleConstant(short s) {
        return (DoubleConstant)this.constants[s];
    }

    public FloatConstant getFloatConstant(short s) {
        return (FloatConstant)this.constants[s];
    }

    public IntegerConstant getIntegerConstant(short s) {
        return (IntegerConstant)this.constants[s];
    }

    public LongConstant getLongConstant(short s) {
        return (LongConstant)this.constants[s];
    }

    public NameAndTypeConstant getNameAndTypeConstant(short s) {
        return (NameAndTypeConstant)this.constants[s];
    }

    public FieldRefConstant getFieldRefConstant(short s) {
        return (FieldRefConstant)this.constants[s];
    }

    public InterfaceMethodRefConstant getInterfaceMethodRefConstant(short s) {
        return (InterfaceMethodRefConstant)this.constants[s];
    }

    public MethodRefConstant getMethodRefConstant(short s) {
        return (MethodRefConstant)this.constants[s];
    }

    public StringConstant getStringConstant(short s) {
        return (StringConstant)this.constants[s];
    }

    public UTF8Constant getUTF8Constant(short s) {
        return (UTF8Constant)this.constants[s];
    }

    public String getUTF8String(short s) {
        return this.getUTF8Constant(s).string();
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.count + " constant(s))";
    }
}

