/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ExceptionHandler {
    private ConstantPool constantPool;
    private short startPC;
    private short endPC;
    private short handlerPC;
    private short catchType;

    ExceptionHandler(ClassFileDataInputStream classFileDataInputStream, ConstantPool constantPool) throws IOException {
        this.constantPool = constantPool;
        this.initialize(classFileDataInputStream);
    }

    void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.startPC = classFileDataInputStream.readU2();
        this.endPC = classFileDataInputStream.readU2();
        this.handlerPC = classFileDataInputStream.readU2();
        this.catchType = classFileDataInputStream.readU2();
    }

    public String displayString() {
        StringWriter stringWriter = new StringWriter(1000);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.println(this.description());
        indentingPrintWriter.indent();
        indentingPrintWriter.print("PC start: ");
        indentingPrintWriter.print(this.startPC);
        indentingPrintWriter.print(" end: ");
        indentingPrintWriter.print(this.endPC);
        indentingPrintWriter.print(" handler: ");
        indentingPrintWriter.println(this.handlerPC);
        indentingPrintWriter.undent();
    }

    public String description() {
        short s = this.catchType;
        if (s == 0) {
            return "finally";
        }
        return "catch (" + this.className(s) + ")";
    }

    public String exceptionClassName() {
        return this.className(this.catchType);
    }

    private String className(short s) {
        return this.constantPool.getClassConstant(s).name();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public short getStartPC() {
        return this.startPC;
    }

    public short getEndPC() {
        return this.endPC;
    }

    public short getHandlerPC() {
        return this.handlerPC;
    }

    public short getCatchType() {
        return this.catchType;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.description() + ')';
    }
}

