/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.Field;
import org.eclipse.persistence.tools.workbench.utility.classfile.Member;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class FieldPool
implements Member.Pool {
    private ClassFile classFile;
    private short count;
    private Field[] fields;

    FieldPool(ClassFileDataInputStream classFileDataInputStream, ClassFile classFile) throws IOException {
        this.classFile = classFile;
        this.initialize(classFileDataInputStream);
    }

    private void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        short s = this.count = classFileDataInputStream.readU2();
        Field[] fieldArray = this.fields = new Field[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            fieldArray[s2] = new Field(classFileDataInputStream, this);
        }
    }

    public String displayString() {
        StringWriter stringWriter = new StringWriter(1000);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        short s = this.count;
        Field[] fieldArray = this.fields;
        indentingPrintWriter.print("Field Pool (count: ");
        indentingPrintWriter.print(s);
        indentingPrintWriter.println(')');
        indentingPrintWriter.indent();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            indentingPrintWriter.print(s2);
            indentingPrintWriter.print(": ");
            fieldArray[s2].displayStringOn(indentingPrintWriter);
        }
        indentingPrintWriter.undent();
    }

    public Field fieldNamed(String string) {
        short s = this.count;
        Field[] fieldArray = this.fields;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            Field field = fieldArray[s2];
            if (!field.name().equals(string)) continue;
            return field;
        }
        throw new IllegalArgumentException(string);
    }

    public Field[] declaredFields() {
        short s = this.count;
        Field[] fieldArray = this.fields;
        ArrayList<Field> arrayList = new ArrayList<Field>(s);
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            Field field = fieldArray[s2];
            if (!field.isDeclaredField()) continue;
            arrayList.add(field);
        }
        return arrayList.toArray(new Field[arrayList.size()]);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short s = this.count;
        Field[] fieldArray = this.fields;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            fieldArray[s2].accept(visitor);
        }
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public short getCount() {
        return this.count;
    }

    public Field get(short s) {
        return this.fields[s];
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.count + " field(s))";
    }
}

