/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class FloatConstant
extends Constant {
    private float value;

    FloatConstant(ConstantPool constantPool, byte by, ClassFileDataInputStream classFileDataInputStream) throws IOException {
        super(constantPool, by, classFileDataInputStream);
    }

    void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.value = Float.intBitsToFloat(classFileDataInputStream.readU4());
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        super.displayStringOn(indentingPrintWriter);
        indentingPrintWriter.print(" value: ");
        indentingPrintWriter.println(this.value);
    }

    public String description() {
        return "float";
    }

    public void printFieldInitializationClauseOn(PrintWriter printWriter) {
        printWriter.print(this.value);
        printWriter.print('F');
    }

    public float floatValue() {
        return this.value;
    }

    public Object value() {
        return new Float(this.value);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

