/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.LineNumber;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class LineNumberTableAttribute
extends Attribute {
    private short count;
    private LineNumber[] lineNumbers;

    LineNumberTableAttribute(ClassFileDataInputStream classFileDataInputStream, short s, AttributePool attributePool) throws IOException {
        super(classFileDataInputStream, s, attributePool);
    }

    void initializeInfo(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        short s = this.count = classFileDataInputStream.readU2();
        LineNumber[] lineNumberArray = this.lineNumbers = new LineNumber[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            lineNumberArray[s2] = new LineNumber(classFileDataInputStream);
        }
    }

    public void displayNameOn(IndentingPrintWriter indentingPrintWriter) {
        super.displayNameOn(indentingPrintWriter);
        indentingPrintWriter.print(" (count: ");
        indentingPrintWriter.print(this.count);
        indentingPrintWriter.print(")");
    }

    void displayInfoStringOn(IndentingPrintWriter indentingPrintWriter) {
        short s = this.count;
        LineNumber[] lineNumberArray = this.lineNumbers;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            indentingPrintWriter.print(s2);
            indentingPrintWriter.print(": ");
            lineNumberArray[s2].displayStringOn(indentingPrintWriter);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short s = this.count;
        LineNumber[] lineNumberArray = this.lineNumbers;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            lineNumberArray[s2].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public LineNumber[] getLineNumbers() {
        return this.lineNumbers;
    }

    public LineNumber getLineNumber(short s) {
        return this.lineNumbers[s];
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.count);
        stringBuffer.append(" line number(s)");
    }
}

