/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.NameAndTypeConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public abstract class MemberRefConstant
extends Constant {
    private short classIndex;
    private short nameAndTypeIndex;

    MemberRefConstant(ConstantPool constantPool, byte by, ClassFileDataInputStream classFileDataInputStream) throws IOException {
        super(constantPool, by, classFileDataInputStream);
    }

    void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.classIndex = classFileDataInputStream.readU2();
        this.nameAndTypeIndex = classFileDataInputStream.readU2();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        super.displayStringOn(indentingPrintWriter);
        indentingPrintWriter.print(" class: ");
        indentingPrintWriter.print(this.className());
        indentingPrintWriter.print("  name: ");
        indentingPrintWriter.print(this.name());
        indentingPrintWriter.print("  descriptor: ");
        indentingPrintWriter.println(this.descriptor());
    }

    public String className() {
        return this.classConstant().name();
    }

    public ClassConstant classConstant() {
        return this.getPool().getClassConstant(this.classIndex);
    }

    public String name() {
        return this.nameAndTypeConstant().name();
    }

    public String descriptor() {
        return this.nameAndTypeConstant().descriptor();
    }

    public NameAndTypeConstant nameAndTypeConstant() {
        return this.getPool().getNameAndTypeConstant(this.nameAndTypeIndex);
    }

    public short getClassIndex() {
        return this.classIndex;
    }

    public short getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    public Object value() {
        return this.className() + '.' + this.name() + ':' + this.descriptor();
    }
}

