/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.FilterReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.persistence.tools.workbench.utility.classfile.Member;
import org.eclipse.persistence.tools.workbench.utility.classfile.MethodPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;

public class Method
extends Member {
    private FieldType returnDescriptor;
    private FieldType[] parameterDescriptors;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_INITIALIZER_NAME = "<clinit>";
    public static final short ACC_BRIDGE = 64;
    public static final short ACC_VARARGS = 128;
    public static final int VISIBLE_ACCESS_FLAGS_MASK = 3391;

    Method(ClassFileDataInputStream classFileDataInputStream, MethodPool methodPool) throws IOException {
        super(classFileDataInputStream, methodPool);
    }

    short visibleAccessFlagsMask() {
        return 3391;
    }

    public void printDeclarationOn(PrintWriter printWriter) {
        if (this.isStaticInitializationMethod()) {
            printWriter.print("<static initialization>");
            return;
        }
        this.printModifierOn(printWriter);
        if (this.isConstructor()) {
            printWriter.print(this.codeConstructorName());
        } else {
            this.getReturnDescriptor().printDeclarationOn(printWriter);
            printWriter.print(' ');
            printWriter.print(this.name());
        }
        printWriter.print('(');
        int n = this.getParameterDescriptors().length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                printWriter.write(", ");
            }
            this.getParameterDescriptor(i).printDeclarationOn(printWriter);
        }
        printWriter.print(')');
        this.getAttributePool().printThrowsClauseOn(printWriter);
    }

    public String javaReturnTypeName() {
        return this.getReturnDescriptor().javaName();
    }

    public String[] javaParameterTypeNames() {
        FieldType[] fieldTypeArray = this.getParameterDescriptors();
        int n = fieldTypeArray.length;
        if (n == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[n];
        int n2 = n;
        while (n2-- > 0) {
            stringArray[n2] = fieldTypeArray[n2].javaName();
        }
        return stringArray;
    }

    public String[] exceptionClassNames() {
        return this.getAttributePool().exceptionClassNames();
    }

    public boolean isConstructor() {
        return this.name().equals(CONSTRUCTOR_NAME);
    }

    public boolean isDeclaredConstructor() {
        if (this.isSynthetic()) {
            return false;
        }
        return this.isConstructor();
    }

    public boolean isDeclaredMethod() {
        if (this.isSynthetic()) {
            return false;
        }
        if (this.isConstructor()) {
            return false;
        }
        return !this.isStaticInitializationMethod();
    }

    public String constructorName() {
        if (!this.isConstructor()) {
            throw new IllegalStateException();
        }
        return this.classFile().className();
    }

    public String codeConstructorName() {
        if (!this.isConstructor()) {
            throw new IllegalStateException();
        }
        if (this.classFile().isNestedClass()) {
            return this.classFile().nestedClassName();
        }
        String string = this.classFile().className();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public boolean isStaticInitializationMethod() {
        return this.name().equals(STATIC_INITIALIZER_NAME);
    }

    public boolean isBridge() {
        return (this.getAccessFlags() & 0x40) != 0;
    }

    public boolean isVarArg() {
        return (this.getAccessFlags() & 0x80) != 0;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.getReturnDescriptor().accept(visitor);
        FieldType[] fieldTypeArray = this.getParameterDescriptors();
        int n = fieldTypeArray.length;
        for (int i = 0; i < n; ++i) {
            fieldTypeArray[i].accept(visitor);
        }
        super.accept(visitor);
    }

    public MethodPool getMethodPool() {
        return (MethodPool)this.getPool();
    }

    public FieldType getReturnDescriptor() {
        if (this.returnDescriptor == null) {
            this.buildDescriptors();
        }
        return this.returnDescriptor;
    }

    public FieldType[] getParameterDescriptors() {
        if (this.parameterDescriptors == null) {
            this.buildDescriptors();
        }
        return this.parameterDescriptors;
    }

    public FieldType getParameterDescriptor(int n) {
        if (this.parameterDescriptors == null) {
            this.buildDescriptors();
        }
        return this.parameterDescriptors[n];
    }

    private void buildDescriptors() {
        StringReader stringReader = new StringReader(this.descriptor());
        try {
            this.parameterDescriptors = Method.buildParameterDescriptors(stringReader);
            this.returnDescriptor = FieldType.createFieldType(stringReader);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static FieldType[] buildParameterDescriptors(Reader reader) throws IOException {
        PeekableReader peekableReader = new PeekableReader(reader);
        int n = peekableReader.read();
        if (n != 40) {
            throw new IllegalStateException("open parenthesis expected: " + (char)n);
        }
        ArrayList<FieldType> arrayList = new ArrayList<FieldType>();
        while (peekableReader.peek() != 41) {
            arrayList.add(FieldType.createFieldType(peekableReader));
        }
        peekableReader.read();
        return arrayList.toArray(new FieldType[arrayList.size()]);
    }

    private static class PeekableReader
    extends FilterReader {
        PeekableReader(Reader reader) {
            super(reader);
        }

        public int peek() throws IOException {
            this.mark(1);
            int n = this.read();
            this.reset();
            return n;
        }
    }
}

