/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.Member;
import org.eclipse.persistence.tools.workbench.utility.classfile.Method;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class MethodPool
implements Member.Pool {
    private ClassFile classFile;
    private short count;
    private Method[] methods;

    MethodPool(ClassFileDataInputStream classFileDataInputStream, ClassFile classFile) throws IOException {
        this.classFile = classFile;
        this.initialize(classFileDataInputStream);
    }

    private void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        short s = this.count = classFileDataInputStream.readU2();
        Method[] methodArray = this.methods = new Method[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            methodArray[s2] = new Method(classFileDataInputStream, this);
        }
    }

    public String displayString() {
        StringWriter stringWriter = new StringWriter(1000);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        short s = this.count;
        Method[] methodArray = this.methods;
        indentingPrintWriter.print("Method Pool (count: ");
        indentingPrintWriter.print(s);
        indentingPrintWriter.println(')');
        indentingPrintWriter.indent();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            indentingPrintWriter.print(s2);
            indentingPrintWriter.print(": ");
            methodArray[s2].displayStringOn(indentingPrintWriter);
        }
        indentingPrintWriter.undent();
    }

    public Method[] declaredConstructors() {
        short s = this.count;
        Method[] methodArray = this.methods;
        ArrayList<Method> arrayList = new ArrayList<Method>(s);
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            Method method = methodArray[s2];
            if (!method.isDeclaredConstructor()) continue;
            arrayList.add(method);
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    public Method[] declaredMethods() {
        short s = this.count;
        Method[] methodArray = this.methods;
        ArrayList<Method> arrayList = new ArrayList<Method>(s);
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            Method method = methodArray[s2];
            if (!method.isDeclaredMethod()) continue;
            arrayList.add(method);
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short s = this.count;
        Method[] methodArray = this.methods;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            methodArray[s2].accept(visitor);
        }
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public short getCount() {
        return this.count;
    }

    public Method get(short s) {
        return this.methods[s];
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.count + " method(s))";
    }
}

