/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class SourceFileAttribute
extends Attribute {
    private short sourceFileIndex;

    SourceFileAttribute(ClassFileDataInputStream classFileDataInputStream, short s, AttributePool attributePool) throws IOException {
        super(classFileDataInputStream, s, attributePool);
    }

    void initializeInfo(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.sourceFileIndex = classFileDataInputStream.readU2();
    }

    void displayInfoStringOn(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.println(this.sourceFileName());
    }

    public String sourceFileName() {
        return this.constantPool().getUTF8String(this.sourceFileIndex);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public short getSourceFileIndex() {
        return this.sourceFileIndex;
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.sourceFileName());
    }
}

