/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class UTF8Constant
extends Constant {
    private String value;

    UTF8Constant(ConstantPool constantPool, byte by, ClassFileDataInputStream classFileDataInputStream) throws IOException {
        super(constantPool, by, classFileDataInputStream);
    }

    void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.value = this.readStringFrom(classFileDataInputStream);
    }

    private String readStringFrom(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        short s = classFileDataInputStream.readU2();
        StringBuffer stringBuffer = new StringBuffer(s);
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            short s3;
            byte by = classFileDataInputStream.readU1();
            if ((by & 0x80) == 0) {
                stringBuffer.append((char)by);
                continue;
            }
            if ((by & 0x40) == 0) {
                throw this.badByte(by);
            }
            if ((by & 0x20) == 0) {
                s3 = (short)((by & 0x1F) << 6);
            } else {
                s3 = (short)((by & 0xF) << 12);
                by = classFileDataInputStream.readU1();
                this.checkContinuation(by);
                s2 = (short)(s2 + 1);
                s3 = (short)(s3 | (by & 0x3F) << 6);
            }
            by = classFileDataInputStream.readU1();
            this.checkContinuation(by);
            s2 = (short)(s2 + 1);
            s3 = (short)(s3 | by & 0x3F);
            stringBuffer.append((char)s3);
        }
        return stringBuffer.toString();
    }

    private final IOException badByte(byte by) {
        return new IOException("Invalid UTF-8 byte: " + Byte.toString(by));
    }

    private final void checkContinuation(byte by) throws IOException {
        if ((by & 0x80) == 0 || (by & 0x40) != 0) {
            throw this.badByte(by);
        }
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        super.displayStringOn(indentingPrintWriter);
        indentingPrintWriter.print(" value: \"");
        indentingPrintWriter.print(this.value);
        indentingPrintWriter.println("\"");
    }

    public String description() {
        return "UTF8";
    }

    public String string() {
        return this.value;
    }

    public Object value() {
        return this.value;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

