/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.descriptor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.ArrayType;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.BaseType;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.ObjectType;

public abstract class FieldType {
    public static FieldType createFieldType(String string) {
        try {
            return FieldType.createFieldType(new StringReader(string));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static FieldType createFieldType(Reader reader) throws IOException {
        int n = reader.read();
        switch (n) {
            case 76: {
                return new ObjectType(reader);
            }
            case 91: {
                return new ArrayType(reader);
            }
        }
        return new BaseType(n);
    }

    public static FieldType createFieldTypeForClassConstant(String string) {
        if (string.charAt(0) == '[') {
            return FieldType.createFieldType(string);
        }
        return new ObjectType(string);
    }

    public abstract void accept(Visitor var1);

    public abstract int arrayDepth();

    public abstract String elementTypeName();

    public abstract String javaName();

    public abstract Class javaClass() throws ClassNotFoundException;

    public String declaration() {
        StringBuffer stringBuffer = new StringBuffer(200);
        this.appendDeclarationTo(stringBuffer);
        return stringBuffer.toString();
    }

    public abstract void appendDeclarationTo(StringBuffer var1);

    public abstract void printDeclarationOn(PrintWriter var1);

    public abstract String internalName();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(ClassTools.shortClassNameForObject(this));
        stringBuffer.append('(');
        this.appendDeclarationTo(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    FieldType() {
    }

    abstract void appendArrayJavaNameTo(StringBuffer var1);

    abstract void appendArrayInternalNameTo(StringBuffer var1);
}

