/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileIterator;

public class ClassDependencyGraph {
    private Collection nodes;
    private Map allNodes;

    public ClassDependencyGraph(String string) {
        this(new ClassFileIterator(string));
    }

    public ClassDependencyGraph(Iterator iterator) {
        this.initialize(iterator);
    }

    private void initialize(Iterator iterator) {
        Iterator iterator2;
        ArrayList<String> arrayList = new ArrayList<String>(500);
        this.allNodes = new HashMap(500);
        while (iterator.hasNext()) {
            iterator2 = (ClassFile)iterator.next();
            arrayList.add(((ClassFile)((Object)iterator2)).className());
            this.addClassDependencyNode((ClassFile)((Object)iterator2));
        }
        this.nodes = new ArrayList(500);
        iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            this.nodes.add(this.allNodes.get(iterator2.next()));
        }
        iterator2 = this.nodes.iterator();
        while (iterator2.hasNext()) {
            ((Node)iterator2.next()).addReferencingNodesFrom(this.nodes);
        }
    }

    private void addClassDependencyNode(ClassFile classFile) {
        String string = classFile.className();
        Node node = (Node)this.allNodes.get(string);
        if (node == null) {
            node = new Node(string);
            this.allNodes.put(string, node);
        }
        node.initialize(classFile, this.allNodes);
    }

    public Iterator nodes() {
        return this.nodes.iterator();
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.nodes.size() + '/' + this.allNodes.size() + " nodes)";
    }

    public static class Node {
        private String className;
        private Map referencedNodes;
        private Map referencingNodes;

        Node(String string) {
            this.className = string;
            this.referencedNodes = new IdentityHashMap();
            this.referencingNodes = new IdentityHashMap();
        }

        void initialize(ClassFile classFile, Map map) {
            if (!this.referencedNodes.isEmpty()) {
                throw new IllegalStateException();
            }
            String[] stringArray = classFile.referencedClassNames();
            int n = stringArray.length;
            while (n-- > 0) {
                String string = stringArray[n];
                Node node = (Node)map.get(string);
                if (node == null) {
                    node = new Node(string);
                    map.put(string, node);
                }
                this.referencedNodes.put(node, node);
            }
        }

        void addReferencingNodesFrom(Collection collection) {
            for (Node node : collection) {
                node.addReferencingNodeTo(this);
            }
        }

        private void addReferencingNodeTo(Node node) {
            if (this.referencedNodes.containsKey(node)) {
                node.addReferencingNode(this);
            }
        }

        void addReferencingNode(Node node) {
            this.referencingNodes.put(node, node);
        }

        public String getClassName() {
            return this.className;
        }

        public Iterator referencedNodes() {
            return this.referencedNodes.keySet().iterator();
        }

        public Iterator referencingNodes() {
            return this.referencingNodes.keySet().iterator();
        }

        public String toString() {
            return ClassTools.toStringClassNameForObject(this) + "(" + this.className + ")";
        }
    }
}

