/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.util.Collection;
import org.eclipse.persistence.tools.workbench.utility.diff.CompositeDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.DifferentiatorAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class CompositeDifferentiator
implements Differentiator {
    private final Differentiator[] differentiators;
    private final boolean comparesValueObjects;

    public CompositeDifferentiator(Collection collection) {
        this(collection.toArray(new Differentiator[collection.size()]));
    }

    public CompositeDifferentiator(Differentiator[] differentiatorArray) {
        this.differentiators = differentiatorArray;
        this.comparesValueObjects = this.buildcomparesValueObjects();
    }

    private boolean buildcomparesValueObjects() {
        int n = this.differentiators.length;
        if (n == 0) {
            return false;
        }
        boolean bl = this.differentiators[n - 1].comparesValueObjects();
        int n2 = n - 1;
        while (n2-- > 0) {
            if (this.differentiators[n2].comparesValueObjects() == bl) continue;
            throw new IllegalStateException("all the component differentiators must match on Differentiator.comparesValueObjects()");
        }
        return bl;
    }

    public Diff diff(Object object, Object object2) {
        return this.diff(object, object2, DifferentiatorAdapter.NORMAL);
    }

    public Diff keyDiff(Object object, Object object2) {
        return this.diff(object, object2, DifferentiatorAdapter.KEY);
    }

    private Diff diff(Object object, Object object2, DifferentiatorAdapter differentiatorAdapter) {
        int n = this.differentiators.length;
        Diff[] diffArray = new Diff[n];
        for (int i = 0; i < n; ++i) {
            diffArray[i] = differentiatorAdapter.diff(this.differentiators[i], object, object2);
        }
        return new CompositeDiff(object, object2, diffArray, this);
    }

    public boolean comparesValueObjects() {
        return this.comparesValueObjects;
    }

    public String toString() {
        return StringTools.buildToStringFor(this);
    }
}

