/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.diff.CompositeDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ContainerDiff
extends CompositeDiff {
    private final Class javaClass;
    private final Object[] removedElements;
    private final Object[] addedElements;

    public ContainerDiff(Class clazz, Object object, Object object2, Diff[] diffArray, Object[] objectArray, Object[] objectArray2, Differentiator differentiator) {
        super(object, object2, diffArray, differentiator);
        this.javaClass = clazz;
        this.removedElements = objectArray;
        this.addedElements = objectArray2;
    }

    public boolean different() {
        if (this.removedElements.length != 0) {
            return true;
        }
        if (this.addedElements.length != 0) {
            return true;
        }
        return super.different();
    }

    public void appendDescription(IndentingPrintWriter indentingPrintWriter) {
        if (this.different()) {
            indentingPrintWriter.print("The ");
            indentingPrintWriter.print(ClassTools.shortNameFor(this.javaClass));
            indentingPrintWriter.print("s are different:");
            indentingPrintWriter.println();
            this.appendDiffs(indentingPrintWriter);
            this.appendRemovedElements(indentingPrintWriter);
            this.appendAddedElements(indentingPrintWriter);
        }
    }

    private void appendDiffs(IndentingPrintWriter indentingPrintWriter) {
        Diff[] diffArray = this.getDiffs();
        boolean bl = false;
        for (Diff diff : diffArray) {
            if (!diff.different()) continue;
            if (!bl) {
                indentingPrintWriter.println("The following pairs of elements have matching \"keys\" but are different:");
                indentingPrintWriter.indent();
                bl = true;
            }
            diff.appendDescription(indentingPrintWriter);
        }
        if (bl) {
            indentingPrintWriter.undent();
        }
    }

    private void appendRemovedElements(IndentingPrintWriter indentingPrintWriter) {
        int n = this.removedElements.length;
        if (n == 0) {
            return;
        }
        indentingPrintWriter.println("The following elements were removed (they existed in container 1, but not in container 2):");
        indentingPrintWriter.indent();
        for (int i = 0; i < n; ++i) {
            indentingPrintWriter.println(this.removedElements[i]);
        }
        indentingPrintWriter.undent();
    }

    private void appendAddedElements(IndentingPrintWriter indentingPrintWriter) {
        int n = this.addedElements.length;
        if (n == 0) {
            return;
        }
        indentingPrintWriter.println("The following elements were added (they existed in container 2, but not in container 1):");
        indentingPrintWriter.indent();
        for (int i = 0; i < n; ++i) {
            indentingPrintWriter.println(this.addedElements[i]);
        }
        indentingPrintWriter.undent();
    }

    public Object[] getAddedElements() {
        return this.addedElements;
    }

    public Object[] getRemovedElements() {
        return this.removedElements;
    }
}

