/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.diff.CompositeDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.DifferentiatorAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.EqualityDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.ReflectiveDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DiffEngine
implements Differentiator {
    private final RecordingDifferentiator recordingDifferentiator = new RecordingDifferentiator();
    private final Map userDifferentiators = new HashMap();
    private final Map reflectiveDifferentiatorCache;
    private final Map differentiatorCache;
    private boolean diffInProgress;
    private Log log;
    private static final Class OBJECT_CLASS = Object.class;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public DiffEngine() {
        this.userDifferentiators.put(OBJECT_CLASS, EqualityDifferentiator.instance());
        this.reflectiveDifferentiatorCache = new HashMap();
        this.differentiatorCache = new HashMap();
        this.diffInProgress = false;
        this.log = Log.NULL_INSTANCE;
    }

    public synchronized Diff diff(Object object, Object object2) {
        return this.diff(object, object2, DifferentiatorAdapter.NORMAL);
    }

    public synchronized Diff keyDiff(Object object, Object object2) {
        return this.diff(object, object2, DifferentiatorAdapter.KEY);
    }

    private Diff diff(Object object, Object object2, DifferentiatorAdapter differentiatorAdapter) {
        this.setUp();
        Diff diff = differentiatorAdapter.diff(this.recordingDifferentiator, object, object2);
        this.tearDown();
        return diff;
    }

    public boolean comparesValueObjects() {
        return false;
    }

    Differentiator differentiatorFor(Object object) {
        return this.differentiatorForClass(object == null ? OBJECT_CLASS : object.getClass());
    }

    private Differentiator differentiatorForClass(Class clazz) {
        Differentiator differentiator = (Differentiator)this.differentiatorCache.get(clazz);
        if (differentiator != null) {
            return differentiator;
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            differentiator = (Differentiator)this.userDifferentiators.get(clazz2);
            if (differentiator == null) continue;
            if (differentiator instanceof ReflectiveDifferentiator) {
                this.expandReflectiveDifferentiatorCache(clazz, differentiator.comparesValueObjects());
                return (Differentiator)this.differentiatorCache.get(clazz);
            }
            this.differentiatorCache.put(clazz, differentiator);
            return differentiator;
        }
        throw new IllegalStateException("missing differentiator: " + clazz.getName());
    }

    public synchronized Differentiator getUserDifferentiator(Class clazz) {
        return (Differentiator)this.userDifferentiators.get(clazz);
    }

    public synchronized Differentiator getDefaultDifferentiator() {
        return (Differentiator)this.userDifferentiators.get(OBJECT_CLASS);
    }

    public synchronized Differentiator getRecordingDifferentiator() {
        return this.recordingDifferentiator;
    }

    private void setUp() {
        if (this.diffInProgress) {
            throw new IllegalStateException("Recursive calls to a DiffEngine are not allowed.");
        }
        this.diffInProgress = true;
        this.checkUserReflectiveDifferentiators();
        this.expandReflectiveDifferentiatorCache();
        this.recordingDifferentiator.setUp();
    }

    private void checkUserReflectiveDifferentiators() {
        for (Map.Entry entry : this.userDifferentiators.entrySet()) {
            Class clazz = (Class)entry.getKey();
            Differentiator differentiator = (Differentiator)entry.getValue();
            if (differentiator instanceof ReflectiveDifferentiator) {
                this.checkUserReflectiveDifferentiator(clazz.getSuperclass());
                this.reflectiveDifferentiatorCache.put(clazz, differentiator);
                continue;
            }
            this.differentiatorCache.put(clazz, differentiator);
        }
    }

    private void checkUserReflectiveDifferentiator(Class clazz) {
        if (clazz == OBJECT_CLASS) {
            return;
        }
        Differentiator differentiator = (Differentiator)this.userDifferentiators.get(clazz);
        if (differentiator != null && !(differentiator instanceof ReflectiveDifferentiator)) {
            throw new IllegalStateException("The differentiator for " + clazz.getName() + " must be reflective: " + differentiator);
        }
        this.checkUserReflectiveDifferentiator(clazz.getSuperclass());
    }

    private void expandReflectiveDifferentiatorCache() {
        for (Map.Entry entry : new HashMap(this.reflectiveDifferentiatorCache).entrySet()) {
            Class clazz = (Class)entry.getKey();
            boolean bl = ((ReflectiveDifferentiator)entry.getValue()).comparesValueObjects();
            this.expandReflectiveDifferentiatorCache(clazz, bl);
        }
    }

    private void expandReflectiveDifferentiatorCache(Class clazz, boolean bl) {
        if (clazz == OBJECT_CLASS) {
            return;
        }
        ReflectiveDifferentiator reflectiveDifferentiator = (ReflectiveDifferentiator)this.reflectiveDifferentiatorCache.get(clazz);
        if (reflectiveDifferentiator == null) {
            reflectiveDifferentiator = new ReflectiveDifferentiator(clazz, this.recordingDifferentiator);
            reflectiveDifferentiator.setComparesValueObjects(bl);
            this.reflectiveDifferentiatorCache.put(clazz, reflectiveDifferentiator);
        }
        this.expandReflectiveDifferentiatorCache(clazz.getSuperclass(), bl);
        this.setUpDifferentiatorCache(clazz);
    }

    private void setUpDifferentiatorCache(Class clazz) {
        Object object;
        if (this.differentiatorCache.get(clazz) != null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (object = clazz; object != OBJECT_CLASS; object = ((Class)object).getSuperclass()) {
            arrayList.add(this.reflectiveDifferentiatorCache.get(object));
        }
        object = null;
        object = arrayList.size() == 1 ? (Differentiator)arrayList.get(0) : new CompositeDifferentiator(CollectionTools.reverse(arrayList));
        this.differentiatorCache.put(clazz, object);
    }

    public synchronized void setDefaultDifferentiator(Differentiator differentiator) {
        this.userDifferentiators.put(OBJECT_CLASS, differentiator);
    }

    public synchronized Differentiator setUserDifferentiator(Class clazz, Differentiator differentiator) {
        if (differentiator == null) {
            throw new NullPointerException();
        }
        if (this.userDifferentiators.put(clazz, differentiator) != null) {
            throw new IllegalArgumentException("duplicate differentiator: " + clazz.getName());
        }
        return differentiator;
    }

    public synchronized Differentiator removeUserDifferentiator(Class clazz) {
        if (clazz == OBJECT_CLASS) {
            throw new IllegalArgumentException("The differentiator for java.lang.Object cannot be removed.");
        }
        return (Differentiator)this.userDifferentiators.remove(clazz);
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class clazz) {
        return this.addReflectiveDifferentiator(clazz, EMPTY_STRING_ARRAY);
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class clazz, String string) {
        return this.addReflectiveDifferentiator(clazz, new String[]{string});
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class clazz, String string, String string2) {
        return this.addReflectiveDifferentiator(clazz, new String[]{string, string2});
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class clazz, String string, String string2, String string3) {
        return this.addReflectiveDifferentiator(clazz, new String[]{string, string2, string3});
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class clazz, String string, String string2, String string3, String string4) {
        return this.addReflectiveDifferentiator(clazz, new String[]{string, string2, string3, string4});
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class clazz, String[] stringArray) {
        return this.addReflectiveDifferentiator(clazz, stringArray, EMPTY_STRING_ARRAY);
    }

    public synchronized ReflectiveDifferentiator addReflectiveDifferentiator(Class clazz, String[] stringArray, String[] stringArray2) {
        ReflectiveDifferentiator reflectiveDifferentiator = new ReflectiveDifferentiator(clazz, this.recordingDifferentiator);
        reflectiveDifferentiator.ignoreFieldsNamed(stringArray);
        reflectiveDifferentiator.addKeyFieldsNamed(stringArray2);
        this.setUserDifferentiator(clazz, reflectiveDifferentiator);
        return reflectiveDifferentiator;
    }

    public void setLog(String string) throws FileNotFoundException {
        this.setLog(new WriterLog(string));
    }

    public void setLog(Log log) {
        this.log = log;
    }

    void log(Diff diff) {
        this.log.log(diff);
    }

    private void tearDown() {
        this.recordingDifferentiator.tearDown();
        this.differentiatorCache.clear();
        this.reflectiveDifferentiatorCache.clear();
        this.diffInProgress = false;
        this.log.close();
    }

    public String toString() {
        return StringTools.buildToStringFor(this);
    }

    private class RecordingDifferentiator
    implements Differentiator {
        private IdentityHashMap previousDiffs1 = new IdentityHashMap();
        private IdentityHashMap previousDiffs2 = new IdentityHashMap();

        RecordingDifferentiator() {
        }

        public Diff diff(Object object, Object object2) {
            Differentiator differentiator = DiffEngine.this.differentiatorFor(object);
            if (!differentiator.comparesValueObjects()) {
                this.checkDiff(object, this.previousDiffs1);
                this.checkDiff(object2, this.previousDiffs2);
            }
            Diff diff = differentiator.diff(object, object2);
            DiffEngine.this.log(diff);
            return diff;
        }

        public Diff keyDiff(Object object, Object object2) {
            Differentiator differentiator = DiffEngine.this.differentiatorFor(object);
            Diff diff = differentiator.keyDiff(object, object2);
            DiffEngine.this.log(diff);
            return diff;
        }

        public boolean comparesValueObjects() {
            return false;
        }

        void setUp() {
        }

        private void checkDiff(Object object, IdentityHashMap identityHashMap) {
            Object object2 = identityHashMap.put(object, object);
            if (object2 != null) {
                throw new IllegalArgumentException("duplicate diff: " + object);
            }
        }

        void tearDown() {
            this.previousDiffs1.clear();
            this.previousDiffs2.clear();
        }

        public String toString() {
            return StringTools.buildToStringFor(this);
        }
    }

    public static class WriterLog
    implements Log {
        private IndentingPrintWriter writer;
        private boolean logsValueDiffs;

        public WriterLog() {
            this(System.out);
        }

        public WriterLog(String string) throws FileNotFoundException {
            this(new File(string));
        }

        public WriterLog(File file) throws FileNotFoundException {
            this(new FileOutputStream(file));
        }

        public WriterLog(OutputStream outputStream) {
            this(new OutputStreamWriter(outputStream));
        }

        public WriterLog(Writer writer) {
            this(new IndentingPrintWriter(new BufferedWriter(writer, 32768)));
        }

        public WriterLog(IndentingPrintWriter indentingPrintWriter) {
            this.writer = indentingPrintWriter;
            this.logsValueDiffs = false;
        }

        public void log(Diff diff) {
            if (diff.getDifferentiator().comparesValueObjects() && !this.logsValueDiffs) {
                return;
            }
            if (diff.identical()) {
                this.writer.println("<no difference>");
                this.writer.print("object 1: ");
                this.writer.println(diff.getObject1());
                this.writer.print("object 2: ");
                this.writer.println(diff.getObject2());
            } else {
                diff.appendDescription(this.writer);
            }
            this.writer.println();
        }

        public void close() {
            this.writer.close();
        }

        public boolean logsValueDiffs() {
            return this.logsValueDiffs;
        }

        public void setLogsValueDiffs(boolean bl) {
            this.logsValueDiffs = bl;
        }
    }

    public static interface Log {
        public static final Log NULL_INSTANCE = new Log(){

            public void log(Diff diff) {
            }

            public void close() {
            }

            public String toString() {
                return "NullLog";
            }
        };

        public void log(Diff var1);

        public void close();
    }
}

