/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public abstract class DiffWrapper
implements Diff {
    protected final Diff diff;
    protected final Differentiator differentiator;

    public DiffWrapper(Diff diff, Differentiator differentiator) {
        this.diff = diff;
        this.differentiator = differentiator;
    }

    public Object getObject1() {
        return this.diff.getObject1();
    }

    public Object getObject2() {
        return this.diff.getObject2();
    }

    public boolean identical() {
        return this.diff.identical();
    }

    public boolean different() {
        return this.diff.different();
    }

    public Differentiator getDifferentiator() {
        return this.differentiator;
    }

    public String getDescription() {
        if (this.diff.identical()) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.diff.appendDescription(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void appendDescription(IndentingPrintWriter indentingPrintWriter) {
        this.diff.appendDescription(indentingPrintWriter);
    }

    public Diff getDiff() {
        return this.diff;
    }

    public String toString() {
        return this.identical() ? "<no difference>" : this.getDescription();
    }
}

