/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Diffable;
import org.eclipse.persistence.tools.workbench.utility.diff.DiffableAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.SimpleDiff;

public class DiffableDifferentiator
implements Differentiator {
    private static DiffableDifferentiator INSTANCE;

    public static synchronized Differentiator instance() {
        if (INSTANCE == null) {
            INSTANCE = new DiffableDifferentiator();
        }
        return INSTANCE;
    }

    private DiffableDifferentiator() {
    }

    public Diff diff(Object object, Object object2) {
        return this.diff(object, object2, DiffableAdapter.NORMAL);
    }

    public Diff keyDiff(Object object, Object object2) {
        return this.diff(object, object2, DiffableAdapter.KEY);
    }

    private String fatalDescriptionTitle() {
        return "The two objects cannot be compared";
    }

    private Diff diff(Object object, Object object2, DiffableAdapter diffableAdapter) {
        if (object == object2) {
            return new NullDiff(object, object2, this);
        }
        if (object == null || object2 == null) {
            return new SimpleDiff(object, object2, this.fatalDescriptionTitle(), this);
        }
        return diffableAdapter.diff((Diffable)object, object2);
    }

    public boolean comparesValueObjects() {
        return false;
    }

    public String toString() {
        return "DiffableDifferentiator";
    }
}

