/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.SimpleDiff;

public class EqualityDifferentiator
implements Differentiator {
    private static EqualityDifferentiator INSTANCE;

    public static synchronized Differentiator instance() {
        if (INSTANCE == null) {
            INSTANCE = new EqualityDifferentiator();
        }
        return INSTANCE;
    }

    private EqualityDifferentiator() {
    }

    public Diff diff(Object object, Object object2) {
        if (this.objectsAreIdentical(object, object2)) {
            return new NullDiff(object, object2, this);
        }
        return new SimpleDiff(object, object2, this.descriptionTitle(), this);
    }

    private boolean objectsAreIdentical(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    private String descriptionTitle() {
        return "Objects are not equal";
    }

    public Diff keyDiff(Object object, Object object2) {
        return this.diff(object, object2);
    }

    public boolean comparesValueObjects() {
        return true;
    }

    public String toString() {
        return "EqualityDifferentiator";
    }
}

