/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.DifferentiatorAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.EqualityDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.MapEntryDiff;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class MapEntryDifferentiator
implements Differentiator {
    private Differentiator keyDifferentiator;
    private Differentiator valueDifferentiator;

    public MapEntryDifferentiator() {
        this(EqualityDifferentiator.instance(), EqualityDifferentiator.instance());
    }

    public MapEntryDifferentiator(Differentiator differentiator, Differentiator differentiator2) {
        this.keyDifferentiator = differentiator;
        this.valueDifferentiator = differentiator2;
    }

    public Diff diff(Object object, Object object2) {
        return this.diff(object, object2, DifferentiatorAdapter.NORMAL);
    }

    public Diff keyDiff(Object object, Object object2) {
        return this.diff(object, object2, DifferentiatorAdapter.KEY);
    }

    private Diff diff(Object object, Object object2, DifferentiatorAdapter differentiatorAdapter) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        Map.Entry entry = (Map.Entry)object;
        Map.Entry entry2 = (Map.Entry)object2;
        Diff diff = differentiatorAdapter.diff(this.keyDifferentiator, entry.getKey(), entry2.getKey());
        Diff diff2 = differentiatorAdapter.diff(this.valueDifferentiator, entry.getValue(), entry2.getValue());
        return new MapEntryDiff(entry, entry2, diff, diff2, this);
    }

    public boolean comparesValueObjects() {
        return false;
    }

    public Differentiator getKeyDifferentiator() {
        return this.keyDifferentiator;
    }

    public void setKeyDifferentiator(Differentiator differentiator) {
        this.keyDifferentiator = differentiator;
    }

    public Differentiator getValueDifferentiator() {
        return this.valueDifferentiator;
    }

    public void setValueDifferentiator(Differentiator differentiator) {
        this.valueDifferentiator = differentiator;
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.valueDifferentiator);
    }
}

