/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.diff.ArrayAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.DifferentiatorAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.EqualityDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.ListAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.OrderedContainerDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.OrderedContainerElementDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.SimpleDiff;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class OrderedContainerDifferentiator
implements Differentiator {
    private Adapter adapter;
    private Differentiator elementDifferentiator;
    static final Object UNDEFINED_ELEMENT = new Object(){

        public String toString() {
            return "<undefined>";
        }
    };

    public static OrderedContainerDifferentiator forLists() {
        return new OrderedContainerDifferentiator(ListAdapter.instance());
    }

    public static OrderedContainerDifferentiator forLists(Differentiator differentiator) {
        return new OrderedContainerDifferentiator(ListAdapter.instance(), differentiator);
    }

    public static OrderedContainerDifferentiator forArrays() {
        return new OrderedContainerDifferentiator(ArrayAdapter.instance());
    }

    public static OrderedContainerDifferentiator forArrays(Differentiator differentiator) {
        return new OrderedContainerDifferentiator(ArrayAdapter.instance(), differentiator);
    }

    public OrderedContainerDifferentiator() {
        this(Adapter.INVALID_INSTANCE);
    }

    public OrderedContainerDifferentiator(Differentiator differentiator) {
        this(Adapter.INVALID_INSTANCE, differentiator);
    }

    public OrderedContainerDifferentiator(Adapter adapter) {
        this(adapter, EqualityDifferentiator.instance());
    }

    public OrderedContainerDifferentiator(Adapter adapter, Differentiator differentiator) {
        this.adapter = adapter;
        this.elementDifferentiator = differentiator;
    }

    public Diff diff(Object object, Object object2) {
        return this.diff(object, object2, DifferentiatorAdapter.NORMAL);
    }

    public Diff keyDiff(Object object, Object object2) {
        return this.diff(object, object2, DifferentiatorAdapter.KEY);
    }

    private Diff diff(Object object, Object object2, DifferentiatorAdapter differentiatorAdapter) {
        Diff[] diffArray;
        block7: {
            Diff diff;
            int n;
            if (object == object2) {
                return new NullDiff(object, object2, this);
            }
            if (this.diffIsFatal(object, object2)) {
                return new SimpleDiff(object, object2, this.fatalDescriptionTitle(), this);
            }
            int n2 = this.size(object);
            int n3 = this.size(object2);
            int n4 = Math.min(n2, n3);
            int n5 = Math.max(n2, n3);
            diffArray = new Diff[n5];
            for (n = 0; n < n4; ++n) {
                diff = differentiatorAdapter.diff(this.elementDifferentiator, this.get(object, n), this.get(object2, n));
                diffArray[n] = new OrderedContainerElementDiff(n, diff, this);
            }
            if (n4 == n5) break block7;
            if (n2 < n3) {
                for (n = n4; n < n5; ++n) {
                    diff = new SimpleDiff(UNDEFINED_ELEMENT, this.get(object2, n), this.missingElementDescriptionTitle(n), this);
                    diffArray[n] = new OrderedContainerElementDiff(n, diff, this);
                }
            } else {
                for (n = n4; n < n5; ++n) {
                    diff = new SimpleDiff(this.get(object, n), UNDEFINED_ELEMENT, this.missingElementDescriptionTitle(n), this);
                    diffArray[n] = new OrderedContainerElementDiff(n, diff, this);
                }
            }
        }
        return new OrderedContainerDiff(this.containerClass(), object, object2, diffArray, this);
    }

    private String missingElementDescriptionTitle(int n) {
        return "Only one of the " + ClassTools.shortNameFor(this.containerClass()) + "s has a value at index " + n;
    }

    private String fatalDescriptionTitle() {
        return "The two " + ClassTools.shortNameFor(this.containerClass()) + "s cannot be compared";
    }

    public boolean comparesValueObjects() {
        return false;
    }

    public Differentiator getElementDifferentiator() {
        return this.elementDifferentiator;
    }

    public void setElementDifferentiator(Differentiator differentiator) {
        this.elementDifferentiator = differentiator;
    }

    protected boolean diffIsFatal(Object object, Object object2) {
        return this.adapter.diffIsFatal(object, object2);
    }

    protected Class containerClass() {
        return this.adapter.containerClass();
    }

    protected int size(Object object) {
        return this.adapter.size(object);
    }

    protected Object get(Object object, int n) {
        return this.adapter.get(object, n);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.elementDifferentiator);
    }

    public static interface Adapter {
        public static final Adapter INVALID_INSTANCE = new Adapter(){

            public boolean diffIsFatal(Object object, Object object2) {
                throw new UnsupportedOperationException();
            }

            public Class containerClass() {
                throw new UnsupportedOperationException();
            }

            public int size(Object object) {
                throw new UnsupportedOperationException();
            }

            public Object get(Object object, int n) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "InvalidAdapter";
            }
        };

        public boolean diffIsFatal(Object var1, Object var2);

        public Class containerClass();

        public int size(Object var1);

        public Object get(Object var1, int var2);
    }
}

