/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.lang.reflect.Method;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ReflectiveChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;

class MultiMethodReflectiveChangeListener
extends ReflectiveChangeListener
implements CollectionChangeListener,
ListChangeListener,
TreeChangeListener {
    private Method addMethod;
    private Method removeMethod;
    private Method replaceMethod;
    private Method changeMethod;

    MultiMethodReflectiveChangeListener(Object object, Method method, Method method2, Method method3, Method method4) {
        super(object);
        this.addMethod = method;
        this.removeMethod = method2;
        this.replaceMethod = method3;
        this.changeMethod = method4;
    }

    MultiMethodReflectiveChangeListener(Object object, Method method, Method method2, Method method3) {
        this(object, method, method2, null, method3);
    }

    private void invoke(Method method, CollectionChangeEvent collectionChangeEvent) {
        if (method.getParameterTypes().length == 0) {
            ClassTools.invokeMethod(method, this.target, EMPTY_COLLECTION_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.invokeMethod(method, this.target, new CollectionChangeEvent[]{collectionChangeEvent});
        }
    }

    public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
        this.invoke(this.addMethod, collectionChangeEvent);
    }

    public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
        this.invoke(this.removeMethod, collectionChangeEvent);
    }

    public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
        this.invoke(this.changeMethod, collectionChangeEvent);
    }

    private void invoke(Method method, ListChangeEvent listChangeEvent) {
        if (method.getParameterTypes().length == 0) {
            ClassTools.invokeMethod(method, this.target, EMPTY_LIST_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.invokeMethod(method, this.target, new ListChangeEvent[]{listChangeEvent});
        }
    }

    public void itemsAdded(ListChangeEvent listChangeEvent) {
        this.invoke(this.addMethod, listChangeEvent);
    }

    public void itemsRemoved(ListChangeEvent listChangeEvent) {
        this.invoke(this.removeMethod, listChangeEvent);
    }

    public void itemsReplaced(ListChangeEvent listChangeEvent) {
        this.invoke(this.replaceMethod, listChangeEvent);
    }

    public void listChanged(ListChangeEvent listChangeEvent) {
        this.invoke(this.changeMethod, listChangeEvent);
    }

    private void invoke(Method method, TreeChangeEvent treeChangeEvent) {
        if (method.getParameterTypes().length == 0) {
            ClassTools.invokeMethod(method, this.target, EMPTY_TREE_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.invokeMethod(method, this.target, new TreeChangeEvent[]{treeChangeEvent});
        }
    }

    public void nodeAdded(TreeChangeEvent treeChangeEvent) {
        this.invoke(this.addMethod, treeChangeEvent);
    }

    public void nodeRemoved(TreeChangeEvent treeChangeEvent) {
        this.invoke(this.removeMethod, treeChangeEvent);
    }

    public void treeChanged(TreeChangeEvent treeChangeEvent) {
        this.invoke(this.changeMethod, treeChangeEvent);
    }
}

