/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.MultiMethodReflectiveChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.SingleMethodReflectiveChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;

public abstract class ReflectiveChangeListener {
    protected Object target;
    protected static final Class StateChangeEvent_class = StateChangeEvent.class;
    protected static final Class[] STATE_CHANGE_EVENT_CLASS_ARRAY = new Class[]{StateChangeEvent_class};
    protected static final StateChangeEvent[] EMPTY_STATE_CHANGE_EVENT_ARRAY = new StateChangeEvent[0];
    protected static final Class PropertyChangeEvent_class = PropertyChangeEvent.class;
    protected static final Class[] PROPERTY_CHANGE_EVENT_CLASS_ARRAY = new Class[]{PropertyChangeEvent_class};
    protected static final PropertyChangeEvent[] EMPTY_PROPERTY_CHANGE_EVENT_ARRAY = new PropertyChangeEvent[0];
    protected static final Class CollectionChangeEvent_class = CollectionChangeEvent.class;
    protected static final Class[] COLLECTION_CHANGE_EVENT_CLASS_ARRAY = new Class[]{CollectionChangeEvent_class};
    protected static final CollectionChangeEvent[] EMPTY_COLLECTION_CHANGE_EVENT_ARRAY = new CollectionChangeEvent[0];
    protected static final Class ListChangeEvent_class = ListChangeEvent.class;
    protected static final Class[] LIST_CHANGE_EVENT_CLASS_ARRAY = new Class[]{ListChangeEvent_class};
    protected static final ListChangeEvent[] EMPTY_LIST_CHANGE_EVENT_ARRAY = new ListChangeEvent[0];
    protected static final Class TreeChangeEvent_class = TreeChangeEvent.class;
    protected static final Class[] TREE_CHANGE_EVENT_CLASS_ARRAY = new Class[]{TreeChangeEvent_class};
    protected static final TreeChangeEvent[] EMPTY_TREE_CHANGE_EVENT_ARRAY = new TreeChangeEvent[0];

    private static Method findChangeListenerMethod(Object object, String string, Class[] classArray) {
        Method method;
        try {
            method = ClassTools.method(object, string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = ClassTools.method(object, string);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException(noSuchMethodException2);
            }
        }
        return method;
    }

    private static void checkChangeListenerMethod(Method method, Class clazz) {
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        if (n == 0) {
            return;
        }
        if (n == 1 && classArray[0].isAssignableFrom(clazz)) {
            return;
        }
        throw new IllegalArgumentException(method.toString());
    }

    public static StateChangeListener buildStateChangeListener(Object object, Method method) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, StateChangeEvent_class);
        return new SingleMethodReflectiveChangeListener(object, method);
    }

    public static StateChangeListener buildStateChangeListener(Object object, String string) {
        return ReflectiveChangeListener.buildStateChangeListener(object, ReflectiveChangeListener.findChangeListenerMethod(object, string, STATE_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static PropertyChangeListener buildPropertyChangeListener(Object object, Method method) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, PropertyChangeEvent_class);
        return new SingleMethodReflectiveChangeListener(object, method);
    }

    public static PropertyChangeListener buildPropertyChangeListener(Object object, String string) {
        return ReflectiveChangeListener.buildPropertyChangeListener(object, ReflectiveChangeListener.findChangeListenerMethod(object, string, PROPERTY_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object object, Method method, Method method2, Method method3) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, CollectionChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(method2, CollectionChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(method3, CollectionChangeEvent_class);
        return new MultiMethodReflectiveChangeListener(object, method, method2, method3);
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object object, Method method) {
        return ReflectiveChangeListener.buildCollectionChangeListener(object, method, method, method);
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object object, String string, String string2, String string3) {
        return ReflectiveChangeListener.buildCollectionChangeListener(object, ReflectiveChangeListener.findChangeListenerMethod(object, string, COLLECTION_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(object, string2, COLLECTION_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(object, string3, COLLECTION_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object object, String string) {
        return ReflectiveChangeListener.buildCollectionChangeListener(object, ReflectiveChangeListener.findChangeListenerMethod(object, string, COLLECTION_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static ListChangeListener buildListChangeListener(Object object, Method method, Method method2, Method method3, Method method4) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, ListChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(method2, ListChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(method3, ListChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(method4, ListChangeEvent_class);
        return new MultiMethodReflectiveChangeListener(object, method, method2, method3, method4);
    }

    public static ListChangeListener buildListChangeListener(Object object, Method method) {
        return ReflectiveChangeListener.buildListChangeListener(object, method, method, method, method);
    }

    public static ListChangeListener buildListChangeListener(Object object, String string, String string2, String string3, String string4) {
        return ReflectiveChangeListener.buildListChangeListener(object, ReflectiveChangeListener.findChangeListenerMethod(object, string, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(object, string2, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(object, string3, LIST_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(object, string4, LIST_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static ListChangeListener buildListChangeListener(Object object, String string) {
        return ReflectiveChangeListener.buildListChangeListener(object, ReflectiveChangeListener.findChangeListenerMethod(object, string, LIST_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static TreeChangeListener buildTreeChangeListener(Object object, Method method, Method method2, Method method3) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, TreeChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(method2, TreeChangeEvent_class);
        ReflectiveChangeListener.checkChangeListenerMethod(method3, TreeChangeEvent_class);
        return new MultiMethodReflectiveChangeListener(object, method, method2, method3);
    }

    public static TreeChangeListener buildTreeChangeListener(Object object, Method method) {
        return ReflectiveChangeListener.buildTreeChangeListener(object, method, method, method);
    }

    public static TreeChangeListener buildTreeChangeListener(Object object, String string, String string2, String string3) {
        return ReflectiveChangeListener.buildTreeChangeListener(object, ReflectiveChangeListener.findChangeListenerMethod(object, string, TREE_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(object, string2, TREE_CHANGE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(object, string3, TREE_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static TreeChangeListener buildTreeChangeListener(Object object, String string) {
        return ReflectiveChangeListener.buildTreeChangeListener(object, ReflectiveChangeListener.findChangeListenerMethod(object, string, TREE_CHANGE_EVENT_CLASS_ARRAY));
    }

    protected ReflectiveChangeListener(Object object) {
        this.target = object;
    }
}

