/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class Pipe {
    private final int bufferSize;
    private final byte[] buffer;
    private final long timeout;
    private final InputStream in = new InputStreamAdapter();
    private final OutputStream out = new OutputStreamAdapter();
    private boolean readLap = false;
    private int readIndex = 0;
    private boolean writeLap = false;
    private int writeIndex = 0;
    private boolean inputStreamClosed = false;
    private boolean outputStreamClosed = false;

    public Pipe() {
        this(2048);
    }

    public Pipe(int n) {
        this(n, 0L);
    }

    public Pipe(int n, long l) {
        this.bufferSize = n;
        this.buffer = new byte[n];
        this.timeout = l;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    synchronized int available() {
        if (this.inputStreamClosed) {
            return 0;
        }
        return this.bytesInPipe();
    }

    private int bytesInPipe() {
        int n = this.writeIndex - this.readIndex;
        if (n == 0) {
            return this.writeLap == this.readLap ? 0 : this.bufferSize;
        }
        return n > 0 ? n : n + this.bufferSize;
    }

    synchronized int read() throws IOException {
        if (this.inputStreamClosed) {
            throw new IOException("Pipe closed");
        }
        long l = System.currentTimeMillis() + this.timeout;
        long l2 = this.timeout;
        while (this.bytesInPipe() == 0) {
            if (this.outputStreamClosed) {
                return -1;
            }
            try {
                this.wait(l2);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            if (this.timeout > 0L && (l2 = l - System.currentTimeMillis()) <= 0L) {
                throw new InterruptedIOException();
            }
            if (!this.inputStreamClosed) continue;
            throw new IOException("Pipe closed");
        }
        byte by = this.buffer[this.readIndex];
        ++this.readIndex;
        if (this.readIndex == this.bufferSize) {
            this.readLap = !this.readLap;
            this.readIndex = 0;
        }
        this.notifyAll();
        return by & 0xFF;
    }

    synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.inputStreamClosed) {
            throw new IOException("Pipe closed");
        }
        long l = System.currentTimeMillis() + this.timeout;
        long l2 = this.timeout;
        int n4 = this.bytesInPipe();
        while (n4 == 0) {
            if (this.outputStreamClosed) {
                return -1;
            }
            try {
                this.wait(l2);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            if (this.timeout > 0L && (l2 = l - System.currentTimeMillis()) <= 0L) {
                throw new InterruptedIOException();
            }
            if (this.inputStreamClosed) {
                throw new IOException("Pipe closed");
            }
            n4 = this.bytesInPipe();
        }
        int n5 = this.bufferSize - this.readIndex;
        int n6 = n2 > n4 ? n4 : n2;
        if (n5 > n6) {
            n5 = n6;
        }
        System.arraycopy(this.buffer, this.readIndex, byArray, n, n5);
        this.readIndex += n5;
        if (this.readIndex == this.bufferSize) {
            this.readLap = !this.readLap;
            this.readIndex = 0;
        }
        if ((n3 = n6 - n5) > 0) {
            System.arraycopy(this.buffer, 0, byArray, n + n5, n3);
            this.readIndex += n3;
        }
        this.notifyAll();
        return n6;
    }

    synchronized void closeInputStream() {
        if (this.inputStreamClosed) {
            throw new IllegalStateException("InputStream already closed");
        }
        this.inputStreamClosed = true;
        this.outputStreamClosed = true;
        this.notifyAll();
    }

    private int freeSpace() {
        int n = this.readIndex - this.writeIndex;
        if (n == 0) {
            return this.writeLap == this.readLap ? this.bufferSize : 0;
        }
        return n > 0 ? n : n + this.bufferSize;
    }

    synchronized void write(int n) throws IOException {
        if (this.outputStreamClosed) {
            throw new IOException("Pipe closed");
        }
        while (this.freeSpace() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            if (!this.outputStreamClosed) continue;
            throw new IOException("Pipe closed");
        }
        this.buffer[this.writeIndex] = (byte)n;
        ++this.writeIndex;
        if (this.writeIndex == this.bufferSize) {
            this.writeLap = !this.writeLap;
            this.writeIndex = 0;
        }
        this.notifyAll();
    }

    synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.outputStreamClosed) {
            throw new IOException("Pipe closed");
        }
        while (n2 > 0) {
            int n3;
            int n4 = this.freeSpace();
            while (n4 == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                if (this.outputStreamClosed) {
                    throw new IOException("Pipe closed");
                }
                n4 = this.freeSpace();
            }
            int n5 = this.bufferSize - this.writeIndex;
            int n6 = n2 > n4 ? n4 : n2;
            if (n5 > n6) {
                n5 = n6;
            }
            System.arraycopy(byArray, n, this.buffer, this.writeIndex, n5);
            this.writeIndex += n5;
            if (this.writeIndex == this.bufferSize) {
                this.writeLap = !this.writeLap;
                this.writeIndex = 0;
            }
            if ((n3 = n6 - n5) > 0) {
                System.arraycopy(byArray, n + n5, this.buffer, 0, n3);
                this.writeIndex += n3;
            }
            n += n6;
            n2 -= n6;
            this.notifyAll();
        }
    }

    synchronized void closeOutputStream() {
        if (this.outputStreamClosed) {
            throw new IllegalStateException("OutputStream already closed");
        }
        this.outputStreamClosed = true;
        this.notifyAll();
    }

    private class OutputStreamAdapter
    extends OutputStream {
        OutputStreamAdapter() {
        }

        public void write(int n) throws IOException {
            Pipe.this.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            Pipe.this.write(byArray, n, n2);
        }

        public void close() throws IOException {
            Pipe.this.closeOutputStream();
        }
    }

    private class InputStreamAdapter
    extends InputStream {
        InputStreamAdapter() {
        }

        public int available() throws IOException {
            return Pipe.this.available();
        }

        public int read() throws IOException {
            return Pipe.this.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return Pipe.this.read(byArray, n, n2);
        }

        public void close() throws IOException {
            Pipe.this.closeInputStream();
        }
    }
}

